/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.ruby;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.runners.ScriptService;
import io.kestra.core.models.tasks.runners.TargetOS;
import io.kestra.core.models.tasks.runners.TaskCommands;
import io.kestra.core.runners.FilesService;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.scripts.exec.AbstractExecScript;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.exec.scripts.models.ScriptOutput;
import io.kestra.plugin.scripts.exec.scripts.runners.CommandsWrapper;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@Schema(title="Execute a Ruby script.")
@Plugin(examples={@Example(full=true, title="Create a Ruby script and execute it. The easiest way to create a Ruby script is to use the embedded VS Code editor. Create a file named `main.rb` and paste the following code:\n\n```ruby\nrequire 'csv'\nrequire 'json'\n\nfile = File.read('data.json')\ndata_hash = JSON.parse(file)\n\n# Extract headers\nheaders = data_hash.first.keys\n\n# Convert hashes to arrays\ndata = data_hash.map(&:values)\n\n# Prepend headers to data\ndata.unshift(headers)\n\n# Create and write data to CSV file\nCSV.open('output.csv', 'wb') do |csv|\ndata.each { |row| csv << row }\nend\n```\n\nIn order to read that script from the [Namespace File](https://kestra.io/docs/developer-guide/namespace-files) called `main.rb`, you can leverage the `{{ read('main.rb') }}` function.\n\nAlso, note how we use the `inputFiles` option to read additional files into the script's working directory. In this case, we read the `data.json` file, which contains the data that we want to convert to CSV.\n\nFinally, we use the `outputFiles` option to specify that we want to output the `output.csv` file that is generated by the script. This allows us to access the file in the UI's Output tab and download it, or pass it to other tasks.\n", code={"id: generate_csv\nnamespace: company.team\ntasks:\n  - id: bash\n    type: io.kestra.plugin.scripts.ruby.Script\n    inputFiles:\n      data.json: |\n        [\n            {\"Name\": \"Alice\", \"Age\": 30, \"City\": \"New York\"},\n            {\"Name\": \"Bob\", \"Age\": 22, \"City\": \"Los Angeles\"},\n            {\"Name\": \"Charlie\", \"Age\": 35, \"City\": \"Chicago\"}\n        ]\n    beforeCommands:\n      - ruby -v\n    script: \"{{ read('main.rb') }}\"\n    outputFiles:\n      - \"*.csv\"\n"})})
public class Script
extends AbstractExecScript {
    private static final String DEFAULT_IMAGE = "ruby";
    protected String containerImage;
    @Schema(title="The inline script content. This property is intended for the script file's content as a (multiline) string, not a path to a file. To run a command from a file such as `bash myscript.sh` or `python myscript.py`, use the `Commands` task instead.")
    @PluginProperty(dynamic=true)
    @NotNull
    @NotEmpty
    protected String script;

    protected DockerOptions injectDefaults(DockerOptions original) {
        DockerOptions.DockerOptionsBuilder builder = original.toBuilder();
        if (original.getImage() == null) {
            builder.image(this.getContainerImage());
        }
        return builder.build();
    }

    public ScriptOutput run(RunContext runContext) throws Exception {
        CommandsWrapper commands = this.commands(runContext);
        Map inputFiles = FilesService.inputFiles((RunContext)runContext, (Map)commands.getTaskRunner().additionalVars(runContext, (TaskCommands)commands), (Object)this.getInputFiles());
        ArrayList internalToLocalFiles = new ArrayList();
        Path relativeScriptPath = runContext.workingDir().path().relativize(runContext.workingDir().createTempFile(".rb"));
        inputFiles.put(relativeScriptPath.toString(), commands.render(runContext, this.script, internalToLocalFiles));
        commands = commands.withInputFiles((Object)inputFiles);
        List commandsArgs = ScriptService.scriptCommands((List)this.interpreter, (List)this.getBeforeCommandsWithOptions(), (String)String.join((CharSequence)" ", DEFAULT_IMAGE, commands.getTaskRunner().toAbsolutePath(runContext, (TaskCommands)commands, relativeScriptPath.toString(), this.targetOS)), (TargetOS)this.targetOS);
        return commands.withCommands(commandsArgs).run();
    }

    @Generated
    private static String $default$containerImage() {
        return DEFAULT_IMAGE;
    }

    @Generated
    protected Script(ScriptBuilder<?, ?> b) {
        super(b);
        this.containerImage = b.containerImage$set ? b.containerImage$value : Script.$default$containerImage();
        this.script = b.script;
    }

    @Generated
    public static ScriptBuilder<?, ?> builder() {
        return new ScriptBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Script(super=" + super.toString() + ", containerImage=" + this.getContainerImage() + ", script=" + this.getScript() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Script)) {
            return false;
        }
        Script other = (Script)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$containerImage = this.getContainerImage();
        String other$containerImage = other.getContainerImage();
        if (this$containerImage == null ? other$containerImage != null : !this$containerImage.equals(other$containerImage)) {
            return false;
        }
        String this$script = this.getScript();
        String other$script = other.getScript();
        return !(this$script == null ? other$script != null : !this$script.equals(other$script));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Script;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $containerImage = this.getContainerImage();
        result = result * 59 + ($containerImage == null ? 43 : $containerImage.hashCode());
        String $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        return result;
    }

    @Generated
    public String getContainerImage() {
        return this.containerImage;
    }

    @Generated
    public String getScript() {
        return this.script;
    }

    @Generated
    public Script() {
        this.containerImage = Script.$default$containerImage();
    }

    @Generated
    public static abstract class ScriptBuilder<C extends Script, B extends ScriptBuilder<C, B>>
    extends AbstractExecScript.AbstractExecScriptBuilder<C, B> {
        @Generated
        private boolean containerImage$set;
        @Generated
        private String containerImage$value;
        @Generated
        private String script;

        @Generated
        public B containerImage(String containerImage) {
            this.containerImage$value = containerImage;
            this.containerImage$set = true;
            return (B)this.self();
        }

        @Generated
        public B script(String script) {
            this.script = script;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Script.ScriptBuilder(super=" + super.toString() + ", containerImage$value=" + this.containerImage$value + ", script=" + this.script + ")";
        }
    }

    @Generated
    private static final class ScriptBuilderImpl
    extends ScriptBuilder<Script, ScriptBuilderImpl> {
        @Generated
        private ScriptBuilderImpl() {
        }

        @Override
        @Generated
        protected ScriptBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Script build() {
            return new Script(this);
        }
    }
}

