/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.runner.memory;

import io.kestra.core.exceptions.DeserializationException;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKilled;
import io.kestra.core.models.executions.ExecutionKilledExecution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.ExecutableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionStorageInterface;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.runners.ExecutableUtils;
import io.kestra.core.runners.ExecutionDelay;
import io.kestra.core.runners.Executor;
import io.kestra.core.runners.ExecutorInterface;
import io.kestra.core.runners.ExecutorService;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.runners.SubflowExecution;
import io.kestra.core.runners.SubflowExecutionResult;
import io.kestra.core.runners.WorkerJob;
import io.kestra.core.runners.WorkerTask;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.services.AbstractFlowTriggerService;
import io.kestra.core.services.ConditionService;
import io.kestra.core.services.ExecutionService;
import io.kestra.core.services.FlowListenersInterface;
import io.kestra.core.services.PluginDefaultService;
import io.kestra.core.services.SkipExecutionService;
import io.kestra.core.storages.Storage;
import io.kestra.core.utils.Either;
import io.kestra.plugin.core.flow.ForEachItem;
import io.kestra.plugin.core.flow.Template;
import io.kestra.runner.memory.MemoryMultipleConditionStorage;
import io.kestra.runner.memory.MemoryQueueEnabled;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@MemoryQueueEnabled
public class MemoryExecutor
implements ExecutorInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemoryExecutor.class);
    private static final ConcurrentHashMap<String, ExecutionState> EXECUTIONS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, SubflowExecution<?>> SUBFLOWEXECUTIONS_WATCHER = new ConcurrentHashMap();
    private List<Flow> allFlows;
    private final ScheduledExecutorService schedulerDelay = Executors.newSingleThreadScheduledExecutor();
    @Inject
    private FlowRepositoryInterface flowRepository;
    @Inject
    @Named(value="executionQueue")
    private QueueInterface<Execution> executionQueue;
    @Inject
    @Named(value="workerJobQueue")
    private QueueInterface<WorkerJob> workerTaskQueue;
    @Inject
    @Named(value="workerTaskResultQueue")
    private QueueInterface<WorkerTaskResult> workerTaskResultQueue;
    @Inject
    @Named(value="workerTaskLogQueue")
    private QueueInterface<LogEntry> logQueue;
    @Inject
    private PluginDefaultService pluginDefaultService;
    @Inject
    private Optional<Template.TemplateExecutorInterface> templateExecutorInterface;
    @Inject
    private ExecutorService executorService;
    @Inject
    private ConditionService conditionService;
    @Inject
    private RunContextFactory runContextFactory;
    @Inject
    private MetricRegistry metricRegistry;
    @Inject
    private ExecutionService executionService;
    @Inject
    protected FlowListenersInterface flowListeners;
    @Inject
    private SkipExecutionService skipExecutionService;
    @Inject
    private AbstractFlowTriggerService flowTriggerService;
    @Inject
    @Named(value="executionKilledQueue")
    protected QueueInterface<ExecutionKilled> killQueue;
    private final MultipleConditionStorageInterface multipleConditionStorage = new MemoryMultipleConditionStorage();
    @Inject
    @Named(value="subflowExecutionResultQueue")
    private QueueInterface<SubflowExecutionResult> subflowExecutionResultQueue;

    public void run() {
        this.flowListeners.run();
        this.flowListeners.listen(flows -> {
            this.allFlows = flows;
        });
        this.executionQueue.receive(MemoryExecutor.class, this::executionQueue);
        this.workerTaskResultQueue.receive(MemoryExecutor.class, this::workerTaskResultQueue);
        this.killQueue.receive(MemoryExecutor.class, this::killQueue);
        this.subflowExecutionResultQueue.receive(Executor.class, this::subflowExecutionResultQueue);
    }

    private void executionQueue(Either<Execution, DeserializationException> either) {
        if (either.isRight()) {
            log.error("Unable to deserialize the execution: {}", (Object)((DeserializationException)either.getRight()).getMessage());
            return;
        }
        Execution message = (Execution)either.getLeft();
        if (this.skipExecutionService.skipExecution(message)) {
            log.warn("Skipping execution {}", (Object)message.getId());
            return;
        }
        if (message.getTaskRunList() == null || message.getTaskRunList().isEmpty() || message.getState().isCreated() || ((State.History)message.getState().getHistories().get(message.getState().getHistories().size() - 2)).getState().equals((Object)State.Type.RETRYING)) {
            this.handleExecution(this.saveExecution(message));
        }
    }

    private Flow transform(Flow flow, Execution execution) {
        if (this.templateExecutorInterface.isPresent()) {
            try {
                flow = Template.injectTemplate((Flow)flow, (Execution)execution, (tenantId, namespace, id) -> this.templateExecutorInterface.get().findById(tenantId, namespace, id).orElse(null));
            }
            catch (InternalException e) {
                log.debug("Failed to inject template", (Throwable)e);
            }
        }
        return this.pluginDefaultService.injectDefaults(flow, execution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExecution(ExecutionState state) {
        MemoryExecutor memoryExecutor = this;
        synchronized (memoryExecutor) {
            Flow flow = this.transform(this.flowRepository.findByExecution(state.execution), state.execution);
            Execution execution = state.execution;
            Executor executor = new Executor(execution, null).withFlow(flow);
            if (log.isDebugEnabled()) {
                this.executorService.log(log, Boolean.valueOf(true), executor);
            }
            if (!(executor = this.executorService.process(executor)).getNexts().isEmpty() && this.deduplicateNexts(execution, executor.getNexts())) {
                executor.withExecution(this.executorService.onNexts(executor.getFlow(), executor.getExecution(), executor.getNexts()), "onNexts");
            }
            if (executor.getException() != null) {
                this.handleFailedExecutionFromExecutor(executor, executor.getException());
            } else if (executor.isExecutionUpdated()) {
                this.toExecution(executor);
            }
            if (!executor.getWorkerTasks().isEmpty()) {
                List<WorkerTask> workerTasksDedup = executor.getWorkerTasks().stream().filter(workerTask -> this.deduplicateWorkerTask(execution, workerTask.getTaskRun())).toList();
                workerTasksDedup.stream().filter(workerTask -> workerTask.getTask().isSendToWorkerTask()).forEach(arg_0 -> this.workerTaskQueue.emit(arg_0));
                workerTasksDedup.stream().filter(workerTask -> workerTask.getTask().isFlowable()).map(workerTask -> new WorkerTaskResult(workerTask.withTaskRun(workerTask.getTaskRun().withState(State.Type.RUNNING)))).forEach(arg_0 -> this.workerTaskResultQueue.emit(arg_0));
            }
            if (!executor.getWorkerTaskResults().isEmpty()) {
                executor.getWorkerTaskResults().forEach(arg_0 -> this.workerTaskResultQueue.emit(arg_0));
            }
            if (!executor.getSubflowExecutionResults().isEmpty()) {
                executor.getSubflowExecutionResults().forEach(arg_0 -> this.subflowExecutionResultQueue.emit(arg_0));
            }
            if (!executor.getExecutionDelays().isEmpty()) {
                executor.getExecutionDelays().forEach(workerTaskResultDelay -> {
                    long between = ChronoUnit.MICROS.between(Instant.now(), workerTaskResultDelay.getDate());
                    if (between <= 0L) {
                        between = 1L;
                    }
                    this.schedulerDelay.schedule(() -> {
                        try {
                            ExecutionState executionState = EXECUTIONS.get(workerTaskResultDelay.getExecutionId());
                            if (workerTaskResultDelay.getDelayType().equals((Object)ExecutionDelay.DelayType.RESUME_FLOW)) {
                                Execution markAsExecution = this.executionService.markAs(executionState.execution, flow, workerTaskResultDelay.getTaskRunId(), workerTaskResultDelay.getState());
                                EXECUTIONS.put(workerTaskResultDelay.getExecutionId(), executionState.from(markAsExecution));
                                this.executionQueue.emit((Object)markAsExecution);
                            } else if (workerTaskResultDelay.getDelayType().equals((Object)ExecutionDelay.DelayType.RESTART_FAILED_TASK)) {
                                Execution newAttempt = this.executionService.retryTask(executionState.execution, workerTaskResultDelay.getTaskRunId());
                                EXECUTIONS.put(workerTaskResultDelay.getExecutionId(), executionState.from(newAttempt));
                                this.executionQueue.emit((Object)newAttempt);
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }, between, TimeUnit.MICROSECONDS);
                });
            }
            if (!executor.getSubflowExecutions().isEmpty()) {
                executor.getSubflowExecutions().forEach(subflowExecution -> {
                    SUBFLOWEXECUTIONS_WATCHER.put(subflowExecution.getExecution().getId(), (SubflowExecution<?>)subflowExecution);
                    this.executionQueue.emit((Object)subflowExecution.getExecution());
                    if (((ExecutableTask)subflowExecution.getParentTask()).waitForExecution()) {
                        this.sendSubflowExecutionResult(execution, (SubflowExecution<?>)subflowExecution, subflowExecution.getParentTaskRun());
                    }
                });
            }
            if (this.conditionService.isTerminatedWithListeners(flow, execution)) {
                this.executionQueue.emit((Object)execution);
            }
            if (this.conditionService.isTerminatedWithListeners(flow, execution)) {
                this.flowTriggerService.computeExecutionsFromFlowTriggers(execution, this.allFlows, Optional.of(this.multipleConditionStorage)).forEach(arg_0 -> this.executionQueue.emit(arg_0));
            }
            if (this.conditionService.isTerminatedWithListeners(flow, execution) && SUBFLOWEXECUTIONS_WATCHER.containsKey(execution.getId())) {
                SubflowExecution<?> subflowExecution2 = SUBFLOWEXECUTIONS_WATCHER.get(execution.getId());
                if (((ExecutableTask)subflowExecution2.getParentTask()).waitForExecution()) {
                    this.sendSubflowExecutionResult(execution, subflowExecution2, subflowExecution2.getParentTaskRun().withState(execution.getState().getCurrent()));
                }
                SUBFLOWEXECUTIONS_WATCHER.remove(execution.getId());
            }
        }
    }

    private void sendSubflowExecutionResult(Execution execution, SubflowExecution<?> subflowExecution, TaskRun taskRun) {
        try {
            Flow workerTaskFlow = this.flowRepository.findByExecution(execution);
            ExecutableTask executableTask = (ExecutableTask)subflowExecution.getParentTask();
            RunContext runContext = this.runContextFactory.of(workerTaskFlow, subflowExecution.getParentTask(), execution, subflowExecution.getParentTaskRun());
            Optional subflowExecutionResult = executableTask.createSubflowExecutionResult(runContext, taskRun, workerTaskFlow, execution);
            subflowExecutionResult.ifPresent(workerTaskResult -> this.subflowExecutionResultQueue.emit(workerTaskResult));
        }
        catch (Exception e) {
            log.error("Unable to create the Subflow Execution Result", (Throwable)e);
            this.subflowExecutionResultQueue.emit((Object)SubflowExecutionResult.builder().executionId(execution.getId()).state(State.Type.FAILED).parentTaskRun(taskRun.withState(State.Type.FAILED).withAttempts(List.of(TaskRunAttempt.builder().state(new State().withState(State.Type.FAILED)).build()))).build());
        }
    }

    private void handleFailedExecutionFromExecutor(Executor executor, Exception e) {
        Execution.FailedExecutionWithLog failedExecutionWithLog = executor.getExecution().failedExecutionFromExecutor(e);
        try {
            failedExecutionWithLog.getLogs().forEach(arg_0 -> this.logQueue.emit(arg_0));
            this.toExecution(executor.withExecution(failedExecutionWithLog.getExecution(), "exception"));
        }
        catch (Exception ex) {
            log.error("Failed to produce {}", (Object)e.getMessage(), (Object)ex);
        }
    }

    private ExecutionState saveExecution(Execution execution) {
        ExecutionState queued = EXECUTIONS.compute(execution.getId(), (s, executionState) -> {
            if (executionState == null) {
                return new ExecutionState(this.runContextFactory, execution);
            }
            return executionState.from(execution);
        });
        return queued;
    }

    private void toExecution(Executor executor) {
        if (log.isDebugEnabled()) {
            this.executorService.log(log, Boolean.valueOf(false), executor);
        }
        this.executionQueue.emit((Object)executor.getExecution());
        this.handleExecution(this.saveExecution(executor.getExecution()));
        if (this.executorService.canBePurged(executor)) {
            EXECUTIONS.remove(executor.getExecution().getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workerTaskResultQueue(Either<WorkerTaskResult, DeserializationException> either) {
        if (either.isRight()) {
            log.error("Unable to deserialize the worker task result: {}", (Object)((DeserializationException)either.getRight()).getMessage());
            return;
        }
        WorkerTaskResult message = (WorkerTaskResult)either.getLeft();
        if (this.skipExecutionService.skipExecution(message.getTaskRun())) {
            log.warn("Skipping execution {}", (Object)message.getTaskRun().getExecutionId());
            return;
        }
        MemoryExecutor memoryExecutor = this;
        synchronized (memoryExecutor) {
            if (log.isDebugEnabled()) {
                this.executorService.log(log, Boolean.valueOf(true), message);
            }
            if (message.getTaskRun().getState().isTerminated()) {
                this.metricRegistry.counter("executor.taskrun.ended.count", this.metricRegistry.tags(message, new String[0])).increment();
                this.metricRegistry.timer("executor.taskrun.ended.duration", this.metricRegistry.tags(message, new String[0])).record(message.getTaskRun().getState().getDuration());
            }
            EXECUTIONS.compute(message.getTaskRun().getExecutionId(), (s, executionState) -> {
                if (executionState == null) {
                    throw new IllegalStateException("Execution state don't exist for " + s + ", receive " + String.valueOf(message));
                }
                if (executionState.execution.hasTaskRunJoinable(message.getTaskRun())) {
                    try {
                        return executionState.from(message, this.executorService, this.executionService, this.flowRepository);
                    }
                    catch (InternalException e) {
                        return new ExecutionState((ExecutionState)executionState, executionState.execution.failedExecutionFromExecutor((Exception)((Object)e)).getExecution());
                    }
                }
                return executionState;
            });
            Flow flow = this.flowRepository.findByExecution(MemoryExecutor.EXECUTIONS.get((Object)message.getTaskRun().getExecutionId()).execution);
            flow = this.transform(flow, MemoryExecutor.EXECUTIONS.get((Object)message.getTaskRun().getExecutionId()).execution);
            this.toExecution(new Executor(MemoryExecutor.EXECUTIONS.get((Object)message.getTaskRun().getExecutionId()).execution, null).withFlow(flow));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subflowExecutionResultQueue(Either<SubflowExecutionResult, DeserializationException> either) {
        if (either.isRight()) {
            log.error("Unable to deserialize the worker task result: {}", (Object)((DeserializationException)either.getRight()).getMessage());
            return;
        }
        SubflowExecutionResult message = (SubflowExecutionResult)either.getLeft();
        if (this.skipExecutionService.skipExecution(message.getExecutionId())) {
            log.warn("Skipping execution {}", (Object)message.getExecutionId());
            return;
        }
        if (this.skipExecutionService.skipExecution(message.getParentTaskRun())) {
            log.warn("Skipping execution {}", (Object)message.getParentTaskRun().getExecutionId());
            return;
        }
        MemoryExecutor memoryExecutor = this;
        synchronized (memoryExecutor) {
            if (log.isDebugEnabled()) {
                this.executorService.log(log, Boolean.valueOf(true), message);
            }
            if (message.getParentTaskRun().getState().isTerminated()) {
                this.metricRegistry.counter("executor.taskrun.ended.count", this.metricRegistry.tags(message, new String[0])).increment();
                this.metricRegistry.timer("executor.taskrun.ended.duration", this.metricRegistry.tags(message, new String[0])).record(message.getParentTaskRun().getState().getDuration());
            }
            EXECUTIONS.compute(message.getParentTaskRun().getExecutionId(), (s, executionState) -> {
                if (executionState == null) {
                    throw new IllegalStateException("Execution state don't exist for " + s + ", receive " + String.valueOf(message));
                }
                if (executionState.execution.hasTaskRunJoinable(message.getParentTaskRun())) {
                    try {
                        return executionState.from(message, this.flowRepository);
                    }
                    catch (InternalException e) {
                        return new ExecutionState((ExecutionState)executionState, executionState.execution.failedExecutionFromExecutor((Exception)((Object)e)).getExecution());
                    }
                }
                return executionState;
            });
            Flow flow = this.flowRepository.findByExecution(MemoryExecutor.EXECUTIONS.get((Object)message.getParentTaskRun().getExecutionId()).execution);
            flow = this.transform(flow, MemoryExecutor.EXECUTIONS.get((Object)message.getParentTaskRun().getExecutionId()).execution);
            this.toExecution(new Executor(MemoryExecutor.EXECUTIONS.get((Object)message.getParentTaskRun().getExecutionId()).execution, null).withFlow(flow));
        }
    }

    private boolean deduplicateWorkerTask(Execution execution, TaskRun taskRun) {
        ExecutionState executionState = EXECUTIONS.get(execution.getId());
        String deduplicationKey = taskRun.getExecutionId() + "-" + taskRun.getId() + "-" + taskRun.attemptNumber();
        State.Type current = executionState.workerTaskDeduplication.get(deduplicationKey);
        if (current == taskRun.getState().getCurrent()) {
            log.trace("Duplicate WorkerTask on execution '{}' for taskRun '{}', value '{}, taskId '{}'", new Object[]{execution.getId(), taskRun.getId(), taskRun.getValue(), taskRun.getTaskId()});
            return false;
        }
        executionState.workerTaskDeduplication.put(deduplicationKey, taskRun.getState().getCurrent());
        return true;
    }

    private boolean deduplicateNexts(Execution execution, List<TaskRun> taskRuns) {
        ExecutionState executionState = EXECUTIONS.get(execution.getId());
        return taskRuns.stream().anyMatch(taskRun -> {
            String deduplicationKey = taskRun.getParentTaskRunId() + "-" + taskRun.getTaskId() + "-" + taskRun.getValue() + taskRun.attemptNumber();
            if (executionState.childDeduplication.containsKey(deduplicationKey)) {
                log.trace("Duplicate Nexts on execution '{}' with key '{}'", (Object)execution.getId(), (Object)deduplicationKey);
                return false;
            }
            executionState.childDeduplication.put(deduplicationKey, taskRun.getId());
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killQueue(Either<ExecutionKilled, DeserializationException> either) {
        if (either.isRight()) {
            log.error("Unable to deserialize a killed execution: {}", (Object)((DeserializationException)either.getRight()).getMessage());
            return;
        }
        Object object = either.getLeft();
        if (!(object instanceof ExecutionKilledExecution)) {
            return;
        }
        ExecutionKilledExecution message = (ExecutionKilledExecution)object;
        if (this.skipExecutionService.skipExecution(message.getExecutionId())) {
            log.warn("Skipping execution {}", (Object)message.getExecutionId());
            return;
        }
        object = this;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                this.executorService.log(log, Boolean.valueOf(true), message);
            }
            Flow flowFromRepository = this.flowRepository.findByExecution(MemoryExecutor.EXECUTIONS.get((Object)message.getExecutionId()).execution);
            EXECUTIONS.compute(message.getExecutionId(), (s, executionState) -> {
                if (executionState == null) {
                    throw new IllegalStateException("Execution state don't exist for " + s + ", receive " + String.valueOf(message));
                }
                return executionState.from(this.executionService.kill(executionState.execution, flowFromRepository));
            });
            Flow flow = this.transform(flowFromRepository, MemoryExecutor.EXECUTIONS.get((Object)message.getExecutionId()).execution);
            this.toExecution(new Executor(MemoryExecutor.EXECUTIONS.get((Object)message.getExecutionId()).execution, null).withFlow(flow));
        }
    }

    public void close() throws IOException {
        this.schedulerDelay.shutdown();
    }

    private static class ExecutionState {
        private RunContextFactory runContextFactory;
        private final Execution execution;
        private Map<String, TaskRun> taskRuns = new ConcurrentHashMap<String, TaskRun>();
        private Map<String, State.Type> workerTaskDeduplication = new ConcurrentHashMap<String, State.Type>();
        private Map<String, String> childDeduplication = new ConcurrentHashMap<String, String>();

        public ExecutionState(RunContextFactory runContextFactory, Execution execution) {
            this.execution = execution;
            this.runContextFactory = runContextFactory;
        }

        public ExecutionState(ExecutionState executionState, Execution execution) {
            this(executionState.runContextFactory, execution);
            this.taskRuns = executionState.taskRuns;
            this.workerTaskDeduplication = executionState.workerTaskDeduplication;
            this.childDeduplication = executionState.childDeduplication;
        }

        private static String taskRunKey(TaskRun taskRun) {
            return taskRun.getId() + "-" + (taskRun.getValue() == null ? "null" : taskRun.getValue());
        }

        public ExecutionState from(Execution execution) {
            List taskRuns = execution.getTaskRunList().stream().map(taskRun -> {
                if (!this.taskRuns.containsKey(ExecutionState.taskRunKey(taskRun))) {
                    return taskRun;
                }
                TaskRun stateTaskRun = this.taskRuns.get(ExecutionState.taskRunKey(taskRun));
                if (execution.hasTaskRunJoinable(stateTaskRun)) {
                    return stateTaskRun;
                }
                return taskRun;
            }).collect(Collectors.toList());
            Execution newExecution = execution.withTaskRunList(taskRuns);
            return new ExecutionState(this, newExecution);
        }

        public ExecutionState from(WorkerTaskResult workerTaskResult, ExecutorService executorService, ExecutionService executionService, FlowRepositoryInterface flowRepository) throws InternalException {
            Flow flow = flowRepository.findByExecution(this.execution);
            TaskRun taskRun = workerTaskResult.getTaskRun();
            this.taskRuns.compute(ExecutionState.taskRunKey(taskRun), (key, value) -> taskRun);
            Execution execution = executorService.addDynamicTaskRun(this.execution, flow, workerTaskResult);
            if (taskRun.getState().getCurrent() == State.Type.KILLED && taskRun.getParentTaskRunId() != null) {
                execution = executionService.killParentTaskruns(taskRun, execution);
            }
            if (execution != null) {
                return new ExecutionState(this, execution);
            }
            return this;
        }

        public ExecutionState from(SubflowExecutionResult subflowExecutionResult, FlowRepositoryInterface flowRepository) throws InternalException {
            TaskRun taskRun;
            Flow flow = flowRepository.findByExecution(this.execution);
            Task task = flow.findTaskByTaskId(subflowExecutionResult.getParentTaskRun().getTaskId());
            if (task instanceof ForEachItem.ForEachItemExecutable) {
                ForEachItem.ForEachItemExecutable forEachItem = (ForEachItem.ForEachItemExecutable)task;
                RunContext runContext = this.runContextFactory.of(flow, task, this.execution, subflowExecutionResult.getParentTaskRun());
                taskRun = ExecutableUtils.manageIterations((Storage)runContext.storage(), (TaskRun)subflowExecutionResult.getParentTaskRun(), (Execution)this.execution, (boolean)forEachItem.getTransmitFailed(), (boolean)forEachItem.isAllowFailure());
            } else {
                taskRun = subflowExecutionResult.getParentTaskRun();
            }
            this.taskRuns.compute(ExecutionState.taskRunKey(taskRun), (key, value) -> taskRun);
            return this;
        }
    }
}

