/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.runner.memory;

import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.schedulers.ScheduleContextInterface;
import io.kestra.core.schedulers.SchedulerTriggerStateInterface;
import io.kestra.runner.memory.MemoryQueueEnabled;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.NotImplementedException;

@Singleton
@MemoryQueueEnabled
public class MemorySchedulerTriggerState
implements SchedulerTriggerStateInterface {
    private final Map<String, Trigger> triggers = new ConcurrentHashMap<String, Trigger>();
    @Inject
    @Named(value="triggerQueue")
    QueueInterface<Trigger> triggerQueue;

    public Optional<Trigger> findLast(TriggerContext context) {
        return Optional.ofNullable(this.triggers.get(context.uid()));
    }

    public List<Trigger> findAllForAllTenants() {
        return new ArrayList<Trigger>(this.triggers.values());
    }

    public Trigger save(Trigger trigger, ScheduleContextInterface scheduleContextInterface) {
        this.triggers.put(trigger.uid(), trigger);
        this.triggerQueue.emit((Object)trigger);
        return trigger;
    }

    public Trigger create(Trigger trigger) {
        this.triggers.put(trigger.uid(), trigger);
        this.triggerQueue.emit((Object)trigger);
        return trigger;
    }

    public Trigger update(Trigger trigger) {
        this.triggers.put(trigger.uid(), trigger);
        this.triggerQueue.emit((Object)trigger);
        return trigger;
    }

    public Trigger update(Flow flow, AbstractTrigger abstractTrigger, ConditionContext conditionContext) throws Exception {
        Optional<Trigger> lastTrigger = this.findLast((TriggerContext)Trigger.of((Flow)flow, (AbstractTrigger)abstractTrigger));
        return this.update(Trigger.of((Flow)flow, (AbstractTrigger)abstractTrigger, (ConditionContext)conditionContext, lastTrigger));
    }

    public List<Trigger> findByNextExecutionDateReadyForAllTenants(ZonedDateTime now, ScheduleContextInterface scheduleContext) {
        return this.triggers.values().stream().filter(trigger -> trigger.getNextExecutionDate() == null || trigger.getNextExecutionDate().isBefore(now)).toList();
    }

    public List<Trigger> findByNextExecutionDateReadyForGivenFlows(List<Flow> flows, ZonedDateTime now, ScheduleContextInterface scheduleContext) {
        throw new NotImplementedException();
    }

    public void unlock(Trigger trigger) {
    }
}

