/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.exec;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.InputFilesInterface;
import io.kestra.core.models.tasks.NamespaceFiles;
import io.kestra.core.models.tasks.NamespaceFilesInterface;
import io.kestra.core.models.tasks.OutputFilesInterface;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.runners.TargetOS;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.core.runner.Process;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.exec.scripts.models.RunnerType;
import io.kestra.plugin.scripts.exec.scripts.models.ScriptOutput;
import io.kestra.plugin.scripts.exec.scripts.runners.CommandsWrapper;
import io.kestra.plugin.scripts.runner.docker.Docker;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;

public abstract class AbstractExecScript
extends Task
implements RunnableTask<ScriptOutput>,
NamespaceFilesInterface,
InputFilesInterface,
OutputFilesInterface {
    @Schema(title="Deprecated - use the 'taskRunner' property instead.", description="Only used if the `taskRunner` property is not set", deprecated=true)
    @PluginProperty
    @Deprecated
    protected RunnerType runner;
    @Schema(title="The task runner to use.", description="Task runners are provided by plugins, each have their own properties.")
    @PluginProperty
    @Valid
    protected TaskRunner taskRunner;
    @Schema(title="A list of commands that will run before the `commands`, allowing to set up the environment e.g. `pip install -r requirements.txt`.")
    @PluginProperty(dynamic=true)
    protected List<String> beforeCommands;
    @Schema(title="Additional environment variables for the current process.")
    @PluginProperty(additionalProperties=String.class, dynamic=true)
    protected Map<String, String> env;
    @Schema(title="Whether to set the task state to `WARNING` if any `stdErr` is emitted.")
    @PluginProperty
    @NotNull
    protected Boolean warningOnStdErr;
    @Schema(title="Which interpreter to use.")
    @PluginProperty
    @NotNull
    @NotEmpty
    protected List<String> interpreter;
    @Schema(title="Fail the task on the first command with a non-zero status.", description="If set to `false` all commands will be executed one after the other. The final state of task execution is determined by the last command. Note that this property maybe be ignored if a non compatible interpreter is specified.\nYou can also disable it if your interpreter does not support the `set -e`option.")
    @PluginProperty
    protected Boolean failFast;
    private NamespaceFiles namespaceFiles;
    private Object inputFiles;
    private List<String> outputFiles;
    @Schema(title="Whether to setup the output directory mechanism.", description="Required to use the {{ outputDir }} expression. Note that it could increase the starting time. Deprecated, use the `outputFiles` property instead.", defaultValue="false", deprecated=true)
    @Deprecated
    private Boolean outputDirectory;
    @Schema(title="The target operating system where the script will run.")
    protected TargetOS targetOS;
    @Schema(title="Deprecated - use the 'taskRunner' property instead.", description="Only used if the `taskRunner` property is not set", deprecated=true)
    @Deprecated
    protected DockerOptions docker;

    @Schema(title="The task runner container image, only used if the task runner is container-based.")
    @PluginProperty(dynamic=true)
    public abstract String getContainerImage();

    protected DockerOptions injectDefaults(@NotNull DockerOptions original) {
        return original;
    }

    protected CommandsWrapper commands(RunContext runContext) throws IllegalVariableEvaluationException {
        if (this.getRunner() == null) {
            runContext.logger().debug("Using task runner '{}'", (Object)this.getTaskRunner().getType());
        }
        return new CommandsWrapper(runContext).withEnv(this.getEnv()).withWarningOnStdErr(this.getWarningOnStdErr()).withRunnerType(this.getRunner()).withContainerImage(runContext.render(this.getContainerImage())).withTaskRunner(this.getTaskRunner()).withDockerOptions(this.getDocker() != null ? this.injectDefaults(this.getDocker()) : null).withNamespaceFiles(this.getNamespaceFiles()).withInputFiles(this.getInputFiles()).withOutputFiles(this.getOutputFiles()).withEnableOutputDirectory(this.getOutputDirectory()).withTimeout(this.getTimeout()).withTargetOS(this.getTargetOS());
    }

    protected List<String> getBeforeCommandsWithOptions() {
        return this.mayAddExitOnErrorCommands(this.getBeforeCommands());
    }

    protected List<String> mayAddExitOnErrorCommands(List<String> commands) {
        if (!this.getFailFast().booleanValue()) {
            return commands;
        }
        if (commands == null || commands.isEmpty()) {
            return this.getExitOnErrorCommands();
        }
        ArrayList<String> newCommands = new ArrayList<String>(commands.size() + 1);
        newCommands.addAll(this.getExitOnErrorCommands());
        newCommands.addAll(commands);
        return newCommands;
    }

    protected List<String> getExitOnErrorCommands() {
        if (this.getTargetOS().equals((Object)TargetOS.WINDOWS) || this.getTargetOS().equals((Object)TargetOS.AUTO) && SystemUtils.IS_OS_WINDOWS && this.getTaskRunner() instanceof Process) {
            return List.of("");
        }
        return List.of("set -e");
    }

    public void kill() {
        if (this.getTaskRunner() != null) {
            this.getTaskRunner().kill();
        }
    }

    @Generated
    private static TaskRunner $default$taskRunner() {
        return ((Docker.DockerBuilder)Docker.builder().type(Docker.class.getName())).build();
    }

    @Generated
    private static Boolean $default$warningOnStdErr() {
        return true;
    }

    @Generated
    private static List<String> $default$interpreter() {
        return List.of("/bin/sh", "-c");
    }

    @Generated
    private static Boolean $default$failFast() {
        return true;
    }

    @Generated
    private static TargetOS $default$targetOS() {
        return TargetOS.AUTO;
    }

    @Generated
    protected AbstractExecScript(AbstractExecScriptBuilder<?, ?> b) {
        super(b);
        this.runner = b.runner;
        this.taskRunner = b.taskRunner$set ? b.taskRunner$value : AbstractExecScript.$default$taskRunner();
        this.beforeCommands = b.beforeCommands;
        this.env = b.env;
        this.warningOnStdErr = b.warningOnStdErr$set ? b.warningOnStdErr$value : AbstractExecScript.$default$warningOnStdErr();
        this.interpreter = b.interpreter$set ? b.interpreter$value : AbstractExecScript.$default$interpreter();
        this.failFast = b.failFast$set ? b.failFast$value : AbstractExecScript.$default$failFast();
        this.namespaceFiles = b.namespaceFiles;
        this.inputFiles = b.inputFiles;
        this.outputFiles = b.outputFiles;
        this.outputDirectory = b.outputDirectory;
        this.targetOS = b.targetOS$set ? b.targetOS$value : AbstractExecScript.$default$targetOS();
        this.docker = b.docker;
    }

    @Generated
    public String toString() {
        return "AbstractExecScript(super=" + super.toString() + ", runner=" + String.valueOf((Object)this.getRunner()) + ", taskRunner=" + String.valueOf(this.getTaskRunner()) + ", beforeCommands=" + String.valueOf(this.getBeforeCommands()) + ", env=" + String.valueOf(this.getEnv()) + ", warningOnStdErr=" + this.getWarningOnStdErr() + ", interpreter=" + String.valueOf(this.getInterpreter()) + ", failFast=" + this.getFailFast() + ", namespaceFiles=" + String.valueOf(this.getNamespaceFiles()) + ", inputFiles=" + String.valueOf(this.getInputFiles()) + ", outputFiles=" + String.valueOf(this.getOutputFiles()) + ", outputDirectory=" + this.getOutputDirectory() + ", targetOS=" + String.valueOf(this.getTargetOS()) + ", docker=" + String.valueOf(this.getDocker()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractExecScript)) {
            return false;
        }
        AbstractExecScript other = (AbstractExecScript)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$warningOnStdErr = this.getWarningOnStdErr();
        Boolean other$warningOnStdErr = other.getWarningOnStdErr();
        if (this$warningOnStdErr == null ? other$warningOnStdErr != null : !((Object)this$warningOnStdErr).equals(other$warningOnStdErr)) {
            return false;
        }
        Boolean this$failFast = this.getFailFast();
        Boolean other$failFast = other.getFailFast();
        if (this$failFast == null ? other$failFast != null : !((Object)this$failFast).equals(other$failFast)) {
            return false;
        }
        Boolean this$outputDirectory = this.getOutputDirectory();
        Boolean other$outputDirectory = other.getOutputDirectory();
        if (this$outputDirectory == null ? other$outputDirectory != null : !((Object)this$outputDirectory).equals(other$outputDirectory)) {
            return false;
        }
        RunnerType this$runner = this.getRunner();
        RunnerType other$runner = other.getRunner();
        if (this$runner == null ? other$runner != null : !((Object)((Object)this$runner)).equals((Object)other$runner)) {
            return false;
        }
        TaskRunner this$taskRunner = this.getTaskRunner();
        TaskRunner other$taskRunner = other.getTaskRunner();
        if (this$taskRunner == null ? other$taskRunner != null : !this$taskRunner.equals(other$taskRunner)) {
            return false;
        }
        List<String> this$beforeCommands = this.getBeforeCommands();
        List<String> other$beforeCommands = other.getBeforeCommands();
        if (this$beforeCommands == null ? other$beforeCommands != null : !((Object)this$beforeCommands).equals(other$beforeCommands)) {
            return false;
        }
        Map<String, String> this$env = this.getEnv();
        Map<String, String> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        List<String> this$interpreter = this.getInterpreter();
        List<String> other$interpreter = other.getInterpreter();
        if (this$interpreter == null ? other$interpreter != null : !((Object)this$interpreter).equals(other$interpreter)) {
            return false;
        }
        NamespaceFiles this$namespaceFiles = this.getNamespaceFiles();
        NamespaceFiles other$namespaceFiles = other.getNamespaceFiles();
        if (this$namespaceFiles == null ? other$namespaceFiles != null : !this$namespaceFiles.equals(other$namespaceFiles)) {
            return false;
        }
        Object this$inputFiles = this.getInputFiles();
        Object other$inputFiles = other.getInputFiles();
        if (this$inputFiles == null ? other$inputFiles != null : !this$inputFiles.equals(other$inputFiles)) {
            return false;
        }
        List<String> this$outputFiles = this.getOutputFiles();
        List<String> other$outputFiles = other.getOutputFiles();
        if (this$outputFiles == null ? other$outputFiles != null : !((Object)this$outputFiles).equals(other$outputFiles)) {
            return false;
        }
        TargetOS this$targetOS = this.getTargetOS();
        TargetOS other$targetOS = other.getTargetOS();
        if (this$targetOS == null ? other$targetOS != null : !this$targetOS.equals(other$targetOS)) {
            return false;
        }
        DockerOptions this$docker = this.getDocker();
        DockerOptions other$docker = other.getDocker();
        return !(this$docker == null ? other$docker != null : !this$docker.equals(other$docker));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractExecScript;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $warningOnStdErr = this.getWarningOnStdErr();
        result = result * 59 + ($warningOnStdErr == null ? 43 : ((Object)$warningOnStdErr).hashCode());
        Boolean $failFast = this.getFailFast();
        result = result * 59 + ($failFast == null ? 43 : ((Object)$failFast).hashCode());
        Boolean $outputDirectory = this.getOutputDirectory();
        result = result * 59 + ($outputDirectory == null ? 43 : ((Object)$outputDirectory).hashCode());
        RunnerType $runner = this.getRunner();
        result = result * 59 + ($runner == null ? 43 : ((Object)((Object)$runner)).hashCode());
        TaskRunner $taskRunner = this.getTaskRunner();
        result = result * 59 + ($taskRunner == null ? 43 : $taskRunner.hashCode());
        List<String> $beforeCommands = this.getBeforeCommands();
        result = result * 59 + ($beforeCommands == null ? 43 : ((Object)$beforeCommands).hashCode());
        Map<String, String> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        List<String> $interpreter = this.getInterpreter();
        result = result * 59 + ($interpreter == null ? 43 : ((Object)$interpreter).hashCode());
        NamespaceFiles $namespaceFiles = this.getNamespaceFiles();
        result = result * 59 + ($namespaceFiles == null ? 43 : $namespaceFiles.hashCode());
        Object $inputFiles = this.getInputFiles();
        result = result * 59 + ($inputFiles == null ? 43 : $inputFiles.hashCode());
        List<String> $outputFiles = this.getOutputFiles();
        result = result * 59 + ($outputFiles == null ? 43 : ((Object)$outputFiles).hashCode());
        TargetOS $targetOS = this.getTargetOS();
        result = result * 59 + ($targetOS == null ? 43 : $targetOS.hashCode());
        DockerOptions $docker = this.getDocker();
        result = result * 59 + ($docker == null ? 43 : $docker.hashCode());
        return result;
    }

    @Deprecated
    @Generated
    public RunnerType getRunner() {
        return this.runner;
    }

    @Generated
    public TaskRunner getTaskRunner() {
        return this.taskRunner;
    }

    @Generated
    public List<String> getBeforeCommands() {
        return this.beforeCommands;
    }

    @Generated
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Generated
    public Boolean getWarningOnStdErr() {
        return this.warningOnStdErr;
    }

    @Generated
    public List<String> getInterpreter() {
        return this.interpreter;
    }

    @Generated
    public Boolean getFailFast() {
        return this.failFast;
    }

    @Generated
    public NamespaceFiles getNamespaceFiles() {
        return this.namespaceFiles;
    }

    @Generated
    public Object getInputFiles() {
        return this.inputFiles;
    }

    @Generated
    public List<String> getOutputFiles() {
        return this.outputFiles;
    }

    @Deprecated
    @Generated
    public Boolean getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public TargetOS getTargetOS() {
        return this.targetOS;
    }

    @Deprecated
    @Generated
    public DockerOptions getDocker() {
        return this.docker;
    }

    @Generated
    public AbstractExecScript() {
        this.taskRunner = AbstractExecScript.$default$taskRunner();
        this.warningOnStdErr = AbstractExecScript.$default$warningOnStdErr();
        this.interpreter = AbstractExecScript.$default$interpreter();
        this.failFast = AbstractExecScript.$default$failFast();
        this.targetOS = AbstractExecScript.$default$targetOS();
    }

    @Generated
    public static abstract class AbstractExecScriptBuilder<C extends AbstractExecScript, B extends AbstractExecScriptBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private RunnerType runner;
        @Generated
        private boolean taskRunner$set;
        @Generated
        private TaskRunner taskRunner$value;
        @Generated
        private List<String> beforeCommands;
        @Generated
        private Map<String, String> env;
        @Generated
        private boolean warningOnStdErr$set;
        @Generated
        private Boolean warningOnStdErr$value;
        @Generated
        private boolean interpreter$set;
        @Generated
        private List<String> interpreter$value;
        @Generated
        private boolean failFast$set;
        @Generated
        private Boolean failFast$value;
        @Generated
        private NamespaceFiles namespaceFiles;
        @Generated
        private Object inputFiles;
        @Generated
        private List<String> outputFiles;
        @Generated
        private Boolean outputDirectory;
        @Generated
        private boolean targetOS$set;
        @Generated
        private TargetOS targetOS$value;
        @Generated
        private DockerOptions docker;

        @Deprecated
        @Generated
        public B runner(RunnerType runner) {
            this.runner = runner;
            return (B)this.self();
        }

        @Generated
        public B taskRunner(TaskRunner taskRunner) {
            this.taskRunner$value = taskRunner;
            this.taskRunner$set = true;
            return (B)this.self();
        }

        @Generated
        public B beforeCommands(List<String> beforeCommands) {
            this.beforeCommands = beforeCommands;
            return (B)this.self();
        }

        @Generated
        public B env(Map<String, String> env) {
            this.env = env;
            return (B)this.self();
        }

        @Generated
        public B warningOnStdErr(Boolean warningOnStdErr) {
            this.warningOnStdErr$value = warningOnStdErr;
            this.warningOnStdErr$set = true;
            return (B)this.self();
        }

        @Generated
        public B interpreter(List<String> interpreter) {
            this.interpreter$value = interpreter;
            this.interpreter$set = true;
            return (B)this.self();
        }

        @Generated
        public B failFast(Boolean failFast) {
            this.failFast$value = failFast;
            this.failFast$set = true;
            return (B)this.self();
        }

        @Generated
        public B namespaceFiles(NamespaceFiles namespaceFiles) {
            this.namespaceFiles = namespaceFiles;
            return (B)this.self();
        }

        @Generated
        public B inputFiles(Object inputFiles) {
            this.inputFiles = inputFiles;
            return (B)this.self();
        }

        @Generated
        public B outputFiles(List<String> outputFiles) {
            this.outputFiles = outputFiles;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B outputDirectory(Boolean outputDirectory) {
            this.outputDirectory = outputDirectory;
            return (B)this.self();
        }

        @Generated
        public B targetOS(TargetOS targetOS) {
            this.targetOS$value = targetOS;
            this.targetOS$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B docker(DockerOptions docker) {
            this.docker = docker;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractExecScript.AbstractExecScriptBuilder(super=" + super.toString() + ", runner=" + String.valueOf((Object)this.runner) + ", taskRunner$value=" + String.valueOf(this.taskRunner$value) + ", beforeCommands=" + String.valueOf(this.beforeCommands) + ", env=" + String.valueOf(this.env) + ", warningOnStdErr$value=" + this.warningOnStdErr$value + ", interpreter$value=" + String.valueOf(this.interpreter$value) + ", failFast$value=" + this.failFast$value + ", namespaceFiles=" + String.valueOf(this.namespaceFiles) + ", inputFiles=" + String.valueOf(this.inputFiles) + ", outputFiles=" + String.valueOf(this.outputFiles) + ", outputDirectory=" + this.outputDirectory + ", targetOS$value=" + String.valueOf(this.targetOS$value) + ", docker=" + String.valueOf(this.docker) + ")";
        }
    }
}

