/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.runner.docker;

import io.kestra.core.models.annotations.PluginProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

@Schema(title="Credentials for a private container registry.")
public class Credentials {
    @Schema(title="The registry URL.", description="If not defined, the registry will be extracted from the image name.")
    @PluginProperty(dynamic=true)
    private String registry;
    @Schema(title="The registry username.")
    @PluginProperty(dynamic=true)
    private String username;
    @Schema(title="The registry password.")
    @PluginProperty(dynamic=true)
    private String password;
    @Schema(title="The registry token.")
    @PluginProperty(dynamic=true)
    private String registryToken;
    @Schema(title="The identity token.")
    @PluginProperty(dynamic=true)
    private String identityToken;
    @Schema(title="The registry authentication.", description="The `auth` field is a base64-encoded authentication string of `username:password` or a token.")
    @PluginProperty(dynamic=true)
    private String auth;

    @Generated
    protected Credentials(CredentialsBuilder<?, ?> b) {
        this.registry = b.registry;
        this.username = b.username;
        this.password = b.password;
        this.registryToken = b.registryToken;
        this.identityToken = b.identityToken;
        this.auth = b.auth;
    }

    @Generated
    public static CredentialsBuilder<?, ?> builder() {
        return new CredentialsBuilderImpl();
    }

    @Generated
    public Credentials() {
    }

    @Generated
    public String getRegistry() {
        return this.registry;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getRegistryToken() {
        return this.registryToken;
    }

    @Generated
    public String getIdentityToken() {
        return this.identityToken;
    }

    @Generated
    public String getAuth() {
        return this.auth;
    }

    @Generated
    public static abstract class CredentialsBuilder<C extends Credentials, B extends CredentialsBuilder<C, B>> {
        @Generated
        private String registry;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private String registryToken;
        @Generated
        private String identityToken;
        @Generated
        private String auth;

        @Generated
        public B registry(String registry) {
            this.registry = registry;
            return this.self();
        }

        @Generated
        public B username(String username) {
            this.username = username;
            return this.self();
        }

        @Generated
        public B password(String password) {
            this.password = password;
            return this.self();
        }

        @Generated
        public B registryToken(String registryToken) {
            this.registryToken = registryToken;
            return this.self();
        }

        @Generated
        public B identityToken(String identityToken) {
            this.identityToken = identityToken;
            return this.self();
        }

        @Generated
        public B auth(String auth) {
            this.auth = auth;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Credentials.CredentialsBuilder(registry=" + this.registry + ", username=" + this.username + ", password=" + this.password + ", registryToken=" + this.registryToken + ", identityToken=" + this.identityToken + ", auth=" + this.auth + ")";
        }
    }

    @Generated
    private static final class CredentialsBuilderImpl
    extends CredentialsBuilder<Credentials, CredentialsBuilderImpl> {
        @Generated
        private CredentialsBuilderImpl() {
        }

        @Override
        @Generated
        protected CredentialsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Credentials build() {
            return new Credentials(this);
        }
    }
}

