/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.runner.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.CreateVolumeResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.StreamType;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.NameParser;
import com.sun.jna.LastErrorException;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.retrys.AbstractRetry;
import io.kestra.core.models.tasks.retrys.Exponential;
import io.kestra.core.models.tasks.runners.RunnerResult;
import io.kestra.core.models.tasks.runners.ScriptService;
import io.kestra.core.models.tasks.runners.TaskCommands;
import io.kestra.core.models.tasks.runners.TaskException;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Await;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.Rethrow;
import io.kestra.core.utils.RetryUtils;
import io.kestra.core.utils.WindowsUtils;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.runner.docker.Cpu;
import io.kestra.plugin.scripts.runner.docker.Credentials;
import io.kestra.plugin.scripts.runner.docker.DeviceRequest;
import io.kestra.plugin.scripts.runner.docker.DockerService;
import io.kestra.plugin.scripts.runner.docker.Memory;
import io.kestra.plugin.scripts.runner.docker.PullPolicy;
import io.micronaut.core.convert.format.ReadableBytesTypeConverter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.Socket;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.slf4j.Logger;

@Schema(title="Run a task in a Docker container.", description="This task runner executes tasks in a container-based Docker-compatible engine.\nUse the `containerImage` property to configure the image for the task.\n\nTo access the task's working directory, use the `{{workingDir}}` Pebble expression\nor the `WORKING_DIR` environment variable.\nInput files and namespace files added to the task will be accessible from that directory.\n\nTo generate output files, we recommend using the `outputFiles` task's property.\nThis allows you to explicitly define which files from the task's working directory\nshould be saved as output files.\n\nAlternatively, when writing files in your task, you can leverage\nthe `{{outputDir}}` Pebble expression or the `OUTPUT_DIR` environment variable.\nAll files written to that directory will be saved as output files automatically.")
@Plugin(examples={@Example(title="Execute a Shell command.", code={"id: simple_shell_example\nnamespace: company.team\n\ntasks:\n  - id: shell\n    type: io.kestra.plugin.scripts.shell.Commands\n    taskRunner:\n      type: io.kestra.plugin.scripts.runner.docker.Docker\n    commands:\n    - echo \"Hello World\""}, full=true), @Example(title="Pass input files to the task, execute a Shell command, then retrieve output files.", code={"id: shell_example_with_files\nnamespace: company.team\n\ninputs:\n  - id: file\n    type: FILE\n\ntasks:\n  - id: shell\n    type: io.kestra.plugin.scripts.shell.Commands\n    inputFiles:\n      data.txt: \"{{ inputs.file }}\"\n    outputFiles:\n      - \"*.txt\"\n    containerImage: centos\n    taskRunner:\n      type: io.kestra.plugin.scripts.runner.docker.Docker\n    commands:\n    - cp {{ workingDir }}/data.txt {{ workingDir }}/out.txt"}, full=true), @Example(title="Run a Python script in Docker and allocate a specific amount of memory.", code={"id: allocate_memory_to_python_script\nnamespace: company.team\n\ntasks:\n  - id: script\n    type: io.kestra.plugin.scripts.python.Script\n    taskRunner:\n      type: io.kestra.plugin.scripts.runner.docker.Docker\n      pullPolicy: IF_NOT_PRESENT\n      cpu:\n        cpus: 1\n      memory: \n        memory: \"512Mb\"\n    containerImage: ghcr.io/kestra-io/kestrapy:latest\n    script: |\n      from kestra import Kestra\n      \n      data = dict(message=\"Hello from Kestra!\")\n      Kestra.outputs(data)"}, full=true)})
public class Docker
extends TaskRunner {
    private static final ReadableBytesTypeConverter READABLE_BYTES_TYPE_CONVERTER = new ReadableBytesTypeConverter();
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("([^\\r\\n]+)[\\r\\n]+");
    private static final String LEGACY_VOLUME_ENABLED_CONFIG = "kestra.tasks.scripts.docker.volume-enabled";
    private static final String VOLUME_ENABLED_CONFIG = "volume-enabled";
    @Schema(title="Docker API URI.")
    @PluginProperty(dynamic=true)
    private String host;
    @Schema(title="Docker configuration file.", description="Docker configuration file that can set access credentials to private container registries. Usually located in `~/.docker/config.json`.", anyOf={String.class, Map.class})
    @PluginProperty(dynamic=true)
    private Object config;
    @Schema(title="Credentials for a private container registry.")
    @PluginProperty(dynamic=true)
    private Credentials credentials;
    @Schema(hidden=true)
    protected String image;
    @Schema(title="User in the Docker container.")
    @PluginProperty(dynamic=true)
    protected String user;
    @Schema(title="Docker entrypoint to use.")
    @PluginProperty(dynamic=true)
    protected List<String> entryPoint;
    @Schema(title="Extra hostname mappings to the container network interface configuration.")
    @PluginProperty(dynamic=true)
    protected List<String> extraHosts;
    @Schema(title="Docker network mode to use e.g. `host`, `none`, etc.")
    @PluginProperty(dynamic=true)
    protected String networkMode;
    @Schema(title="List of volumes to mount.", description="Make sure to provide a map of a local path to a container path in the format: `/home/local/path:/app/container/path`.\nVolume mounts are disabled by default for security reasons \u2014 if you are sure you want to use them,\nenable that feature in the [plugin configuration](https://kestra.io/docs/configuration-guide/plugins)\nby setting `volume-enabled` to `true`.\n\nHere is how you can add that setting to your kestra configuration:\n```yaml\nkestra:\n  plugins:\n    configurations:\n      - type: io.kestra.plugin.scripts.runner.docker.Docker\n        values:\n          volume-enabled: true\n```")
    @PluginProperty(dynamic=true)
    protected List<String> volumes;
    @Schema(title="The pull policy for a container image.", description="Use the `IF_NOT_PRESENT` pull policy to avoid pulling already existing images.\nUse the `ALWAYS` pull policy to pull the latest version of an image\neven if an image with the same tag already exists.")
    @PluginProperty
    protected PullPolicy pullPolicy;
    @Schema(title="A list of device requests to be sent to device drivers.")
    @PluginProperty
    protected List<DeviceRequest> deviceRequests;
    @Schema(title="Limits the CPU usage to a given maximum threshold value.", description="By default, each container\u2019s access to the host machine\u2019s CPU cycles is unlimited. You can set various constraints to limit a given container\u2019s access to the host machine\u2019s CPU cycles.")
    @PluginProperty
    protected Cpu cpu;
    @Schema(title="Limits memory usage to a given maximum threshold value.", description="Docker can enforce hard memory limits, which allow the container to use no more than a given amount of user or system memory, or soft limits, which allow the container to use as much memory as it needs unless certain conditions are met, such as when the kernel detects low memory or contention on the host machine. Some of these options have different effects when used alone or when more than one option is set.")
    @PluginProperty
    protected Memory memory;
    @Schema(title="Size of `/dev/shm` in bytes.", description="The size must be greater than 0. If omitted, the system uses 64MB.")
    @PluginProperty(dynamic=true)
    private String shmSize;
    @Schema(title="File handling strategy.", description="How to handle local files (input files, output files, namespace files, ...).\nBy default, we create a volume and copy the file into the volume bind path.\nConfiguring it to `MOUNT` will mount the working directory instead.")
    @NotNull
    @PluginProperty
    private FileHandlingStrategy fileHandlingStrategy;
    @Schema(title="Whether the container should be deleted upon completion.")
    @NotNull
    @PluginProperty
    private Boolean delete;

    public static Docker instance() {
        return ((DockerBuilder)Docker.builder().type(Docker.class.getName())).build();
    }

    public static Docker from(DockerOptions dockerOptions) {
        if (dockerOptions == null) {
            return Docker.builder().build();
        }
        return ((DockerBuilder)((Object)((DockerBuilder)((Object)((DockerBuilder)((Object)((DockerBuilder)((Object)((DockerBuilder)((Object)((DockerBuilder)((Object)((DockerBuilder)((Object)((DockerBuilder)((Object)((DockerBuilder)((Object)((DockerBuilder)((Object)((DockerBuilder)((Object)((DockerBuilder)((Object)((DockerBuilder)((Object)((DockerBuilder)((Object)((DockerBuilder)Docker.builder().type(Docker.class.getName())).host(dockerOptions.getHost()))).config(dockerOptions.getConfig()))).credentials(dockerOptions.getCredentials()))).image(dockerOptions.getImage()))).user(dockerOptions.getUser()))).entryPoint(dockerOptions.getEntryPoint()))).extraHosts(dockerOptions.getExtraHosts()))).networkMode(dockerOptions.getNetworkMode()))).volumes(dockerOptions.getVolumes()))).pullPolicy(dockerOptions.getPullPolicy()))).deviceRequests(dockerOptions.getDeviceRequests()))).cpu(dockerOptions.getCpu()))).memory(dockerOptions.getMemory()))).shmSize(dockerOptions.getShmSize()))).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public RunnerResult run(RunContext runContext, TaskCommands taskCommands, List<String> filesToDownload) throws Exception {
        if (taskCommands.getContainerImage() == null && this.image == null) {
            throw new IllegalArgumentException("This task runner needs the `containerImage` property to be set");
        }
        if (this.image == null) {
            this.image = taskCommands.getContainerImage();
        }
        logger = runContext.logger();
        defaultLogConsumer = taskCommands.getLogConsumer();
        additionalVars = this.additionalVars(runContext, taskCommands);
        image = runContext.render(this.image, additionalVars);
        resolvedHost = DockerService.findHost(runContext, this.host);
        try {
            dockerClient = this.dockerClient(runContext, image, resolvedHost);
            try {
                if (this.getPullPolicy() != PullPolicy.NEVER) {
                    this.pullImage(dockerClient, image, this.getPullPolicy(), logger);
                }
                container = this.configure(taskCommands, dockerClient, runContext, additionalVars);
                exec = container.exec();
                if (logger.isTraceEnabled()) {
                    logger.trace("Container created: {}", (Object)exec.getId());
                }
                hasFilesToUpload = ListUtils.isEmpty((List)(relativeWorkingDirectoryFilesPaths = taskCommands.relativeWorkingDirectoryFilesPaths(true))) == false;
                hasFilesToDownload = ListUtils.isEmpty(filesToDownload) == false;
                outputDirectoryEnabled = taskCommands.outputDirectoryEnabled();
                needVolume = hasFilesToDownload != false || hasFilesToUpload != false || outputDirectoryEnabled != false;
                filesVolumeName = null;
                if (needVolume && this.fileHandlingStrategy == FileHandlingStrategy.VOLUME) {
                    files = dockerClient.createVolumeCmd().withLabels(ScriptService.labels((RunContext)runContext, (String)"kestra.io/"));
                    filesVolumeName = ((CreateVolumeResponse)files.exec()).getName();
                    if (logger.isTraceEnabled()) {
                        logger.trace("Volume created: {}", (Object)filesVolumeName);
                    }
                    remotePath = WindowsUtils.windowsToUnixPath((String)taskCommands.getWorkingDirectory().toString());
                    fileArchive = runContext.workingDir().createFile("inputFiles.tart");
                    fos = new FileOutputStream(fileArchive.toString());
                    try {
                        out = new TarArchiveOutputStream((OutputStream)fos);
                        try {
                            out.setLongFileMode(3);
                            for (Path file : relativeWorkingDirectoryFilesPaths) {
                                resolvedFile = runContext.workingDir().resolve(file);
                                entry = out.createArchiveEntry(resolvedFile.toFile(), file.toString());
                                out.putArchiveEntry(entry);
                                if (!Files.isDirectory(resolvedFile, new LinkOption[0])) {
                                    fis = Files.newInputStream(resolvedFile, new OpenOption[0]);
                                    try {
                                        IOUtils.copy((InputStream)fis, (OutputStream)out);
                                    }
                                    finally {
                                        if (fis != null) {
                                            fis.close();
                                        }
                                    }
                                }
                                out.closeArchiveEntry();
                            }
                            out.finish();
                        }
                        finally {
                            out.close();
                        }
                    }
                    finally {
                        fos.close();
                    }
                    is = new FileInputStream(fileArchive.toString());
                    try {
                        copyArchiveToContainerCmd = dockerClient.copyArchiveToContainerCmd(exec.getId()).withTarInputStream((InputStream)is).withRemotePath(remotePath);
                        copyArchiveToContainerCmd.exec();
                    }
                    finally {
                        is.close();
                    }
                    Files.delete(fileArchive);
                    if (taskCommands.outputDirectoryEnabled()) {
                        copyArchiveToContainerCmd = dockerClient.copyArchiveToContainerCmd(exec.getId()).withHostResource(taskCommands.getOutputDirectory().toString()).withRemotePath(remotePath);
                        copyArchiveToContainerCmd.exec();
                    }
                }
                dockerClient.startContainerCmd(exec.getId()).exec();
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting command with container id {} [{}]", (Object)exec.getId(), (Object)String.join((CharSequence)" ", taskCommands.getCommands()));
                }
                this.onKill((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$run$0(com.github.dockerjava.api.DockerClient com.github.dockerjava.api.command.CreateContainerResponse org.slf4j.Logger ), ()V)((Docker)this, (DockerClient)dockerClient, (CreateContainerResponse)exec, (Logger)logger));
                ended = new AtomicBoolean(false);
                try {
                    dockerClient.logContainerCmd(exec.getId()).withFollowStream(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).exec((ResultCallback)new ResultCallback.Adapter<Frame>(this){
                        private final Map<StreamType, StringBuilder> logBuffers = new HashMap<StreamType, StringBuilder>();

                        public void onNext(Frame frame) {
                            String frameStr = new String(frame.getPayload());
                            Matcher newLineMatcher = NEWLINE_PATTERN.matcher(frameStr);
                            this.logBuffers.computeIfAbsent(frame.getStreamType(), streamType -> new StringBuilder());
                            int lastIndex = 0;
                            while (newLineMatcher.find()) {
                                String fragment = newLineMatcher.group(0);
                                this.logBuffers.get(frame.getStreamType()).append(fragment);
                                StringBuilder logBuffer = this.logBuffers.get(frame.getStreamType());
                                this.send(logBuffer.toString(), frame.getStreamType() == StreamType.STDERR);
                                logBuffer.setLength(0);
                                lastIndex = newLineMatcher.end();
                            }
                            if (lastIndex < frameStr.length()) {
                                this.logBuffers.get(frame.getStreamType()).append(frameStr.substring(lastIndex));
                            }
                        }

                        private void send(String logBuffer, Boolean isStdErr) {
                            List.of(logBuffer.split("\n")).forEach(s -> defaultLogConsumer.accept(s, (Object)isStdErr));
                        }

                        public void onComplete() {
                            try {
                                this.logBuffers.entrySet().stream().filter(entry -> !((StringBuilder)entry.getValue()).isEmpty()).forEach(Rethrow.throwConsumer(entry -> {
                                    String log = ((StringBuilder)entry.getValue()).toString();
                                    this.send(log, entry.getKey() == StreamType.STDERR);
                                }));
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            ended.set(true);
                            super.onComplete();
                        }
                    });
                    result = dockerClient.waitContainerCmd(exec.getId()).start();
                    exitCode = result.awaitStatusCode();
                    Await.until((BooleanSupplier)(BooleanSupplier)LambdaMetafactory.metafactory(null, null, null, ()Z, get(), ()Z)((AtomicBoolean)ended));
                    if (exitCode != 0) {
                        throw new TaskException(exitCode.intValue(), defaultLogConsumer.getStdOutCount(), defaultLogConsumer.getStdErrCount());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Command succeed with code {}", (Object)exitCode);
                    }
                    if (needVolume && this.fileHandlingStrategy == FileHandlingStrategy.VOLUME && filesVolumeName != null) {
                        copyArchiveFromContainerCmd = dockerClient.copyArchiveFromContainerCmd(exec.getId(), WindowsUtils.windowsToUnixPath((String)taskCommands.getWorkingDirectory().toString()));
                        is = copyArchiveFromContainerCmd.exec();
                        try {
                            tar = new TarArchiveInputStream(is);
                            try {
                                while ((entry = tar.getNextEntry()) != null) {
                                    extractTo = runContext.workingDir().resolve(Path.of(entry.getName().substring(runContext.workingDir().id().length() + 1), new String[0]));
                                    if (entry.isDirectory()) {
                                        if (Files.exists(extractTo, new LinkOption[0])) continue;
                                        Files.createDirectories(extractTo, new FileAttribute[0]);
                                        continue;
                                    }
                                    Files.copy((InputStream)tar, extractTo, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                                }
                            }
                            finally {
                                tar.close();
                            }
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    var21_28 = new RunnerResult(exitCode.intValue(), defaultLogConsumer);
                }
                catch (Throwable var30_48) {
                    try {
                        this.kill();
                        if (Boolean.TRUE.equals(this.delete)) {
                            dockerClient.removeContainerCmd(exec.getId()).exec();
                            if (logger.isTraceEnabled()) {
                                logger.trace("Container deleted: {}", (Object)exec.getId());
                            }
                            if (needVolume && this.fileHandlingStrategy == FileHandlingStrategy.VOLUME && filesVolumeName != null) {
                                dockerClient.removeVolumeCmd(filesVolumeName).exec();
                                if (logger.isTraceEnabled()) {
                                    logger.trace("Volume deleted: {}", (Object)filesVolumeName);
                                }
                            }
                        }
                    }
                    catch (Exception var31_49) {
                        // empty catch block
                    }
                    throw var30_48;
                }
                try {
                    this.kill();
                    if (!Boolean.TRUE.equals(this.delete)) ** GOTO lbl157
                    dockerClient.removeContainerCmd(exec.getId()).exec();
                    if (logger.isTraceEnabled()) {
                        logger.trace("Container deleted: {}", (Object)exec.getId());
                    }
                    if (!needVolume || this.fileHandlingStrategy != FileHandlingStrategy.VOLUME || filesVolumeName == null) ** GOTO lbl157
                    dockerClient.removeVolumeCmd(filesVolumeName).exec();
                    if (!logger.isTraceEnabled()) ** GOTO lbl157
                    logger.trace("Volume deleted: {}", (Object)filesVolumeName);
                }
                catch (Exception var22_32) {
                    // empty catch block
                }
lbl157:
                // 5 sources

                return var21_28;
            }
            finally {
                if (dockerClient != null) {
                    dockerClient.close();
                }
            }
        }
        catch (RuntimeException e) {
            try {
                var12_19 = e.getCause();
                if (var12_19 instanceof IOException && (var12_19 = (io = (IOException)var12_19).getCause()) instanceof LastErrorException && (socketException = (LastErrorException)var12_19).getMessage().contains("No such file or directory") && Socket.class.isAssignableFrom(Class.forName(io.getStackTrace()[0].getClassName()))) {
                    throw new IllegalStateException("Docker socket is not accessible or not found. Please make sure you properly mounted the Docker socket into your Kestra container (`-v /var/run/docker.sock:/var/run/docker.sock`) and that your user or group has at least the read and write privilege. Tried socket: " + resolvedHost, e);
                }
            }
            catch (ClassNotFoundException ignored) {
                throw e;
            }
            throw e;
        }
    }

    private void kill(DockerClient dockerClient, String containerId, Logger logger) {
        try {
            InspectContainerResponse inspect = dockerClient.inspectContainerCmd(containerId).exec();
            if (Boolean.TRUE.equals(inspect.getState().getRunning())) {
                dockerClient.killContainerCmd(containerId).exec();
                if (logger.isTraceEnabled()) {
                    logger.trace("Container was killed.");
                }
            }
        }
        catch (NotFoundException inspect) {
        }
        catch (Exception e) {
            logger.error("Failed to kill running container.", (Throwable)e);
        }
    }

    public Map<String, Object> runnerAdditionalVars(RunContext runContext, TaskCommands taskCommands) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("workingDir", taskCommands.getWorkingDirectory());
        if (taskCommands.outputDirectoryEnabled()) {
            vars.put("outputDir", taskCommands.getOutputDirectory());
        }
        return vars;
    }

    private DockerClient dockerClient(RunContext runContext, String image, String host) throws IOException, IllegalVariableEvaluationException {
        DefaultDockerClientConfig.Builder dockerClientConfigBuilder = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(host);
        if (this.getConfig() != null || this.getCredentials() != null) {
            Path config = DockerService.createConfig(runContext, this.getConfig(), this.getCredentials() != null ? List.of(this.getCredentials()) : null, image);
            dockerClientConfigBuilder.withDockerConfig(config.toFile().getAbsolutePath());
        }
        DefaultDockerClientConfig dockerClientConfig = dockerClientConfigBuilder.build();
        return DockerService.client((DockerClientConfig)dockerClientConfig);
    }

    private CreateContainerCmd configure(TaskCommands taskCommands, DockerClient dockerClient, RunContext runContext, Map<String, Object> additionalVars) throws IllegalVariableEvaluationException {
        Optional property;
        Optional volumeEnabledConfig = runContext.pluginConfiguration(VOLUME_ENABLED_CONFIG);
        if (volumeEnabledConfig.isEmpty() && (property = ((DefaultRunContext)runContext).getApplicationContext().getProperty(LEGACY_VOLUME_ENABLED_CONFIG, Boolean.class)).isPresent()) {
            runContext.logger().warn("`{}` is deprecated, please use the plugin configuration `{}` instead", (Object)LEGACY_VOLUME_ENABLED_CONFIG, (Object)VOLUME_ENABLED_CONFIG);
            volumeEnabledConfig = property;
        }
        boolean volumesEnabled = volumeEnabledConfig.orElse(Boolean.FALSE);
        Path workingDirectory = taskCommands.getWorkingDirectory();
        String image = runContext.render(this.image, additionalVars);
        CreateContainerCmd container = dockerClient.createContainerCmd(image).withLabels(ScriptService.labels((RunContext)runContext, (String)"kestra.io/"));
        HostConfig hostConfig = new HostConfig();
        container.withEnv(this.env(runContext, taskCommands).entrySet().stream().map(r -> (String)r.getKey() + "=" + (String)r.getValue()).toList());
        if (workingDirectory != null) {
            container.withWorkingDir(WindowsUtils.windowsToUnixPath((String)workingDirectory.toAbsolutePath().toString()));
        }
        if (this.getUser() != null) {
            container.withUser(runContext.render(this.getUser(), additionalVars));
        }
        if (this.getEntryPoint() != null) {
            container.withEntrypoint(runContext.render(this.getEntryPoint(), additionalVars));
        }
        if (this.getExtraHosts() != null) {
            hostConfig.withExtraHosts((String[])runContext.render(this.getExtraHosts(), additionalVars).toArray(String[]::new));
        }
        ArrayList<Bind> binds = new ArrayList<Bind>();
        if (this.fileHandlingStrategy == FileHandlingStrategy.MOUNT && workingDirectory != null) {
            String bindPath = WindowsUtils.windowsToUnixPath((String)workingDirectory.toString());
            binds.add(new Bind(bindPath, new Volume(bindPath), AccessMode.rw));
        }
        if (volumesEnabled && this.getVolumes() != null) {
            binds.addAll(runContext.render(this.getVolumes()).stream().map(Bind::parse).toList());
        }
        if (!binds.isEmpty()) {
            hostConfig.withBinds(binds);
        }
        if (this.getDeviceRequests() != null) {
            hostConfig.withDeviceRequests(this.getDeviceRequests().stream().map(Rethrow.throwFunction(deviceRequest -> new com.github.dockerjava.api.model.DeviceRequest().withDriver(runContext.render(deviceRequest.getDriver())).withCount(deviceRequest.getCount()).withDeviceIds(runContext.render(deviceRequest.getDeviceIds())).withCapabilities(deviceRequest.getCapabilities()).withOptions(deviceRequest.getOptions()))).toList());
        }
        if (this.getCpu() != null && this.getCpu().getCpus() != null) {
            hostConfig.withCpuQuota(Long.valueOf(this.getCpu().getCpus() * 10000L));
        }
        if (this.getMemory() != null) {
            if (this.getMemory().getMemory() != null) {
                hostConfig.withMemory(Docker.convertBytes(runContext.render(this.getMemory().getMemory())));
            }
            if (this.getMemory().getMemorySwap() != null) {
                hostConfig.withMemorySwap(Docker.convertBytes(runContext.render(this.getMemory().getMemorySwap())));
            }
            if (this.getMemory().getMemorySwappiness() != null) {
                hostConfig.withMemorySwappiness(Docker.convertBytes(runContext.render(this.getMemory().getMemorySwappiness())));
            }
            if (this.getMemory().getMemoryReservation() != null) {
                hostConfig.withMemoryReservation(Docker.convertBytes(runContext.render(this.getMemory().getMemoryReservation())));
            }
            if (this.getMemory().getKernelMemory() != null) {
                hostConfig.withKernelMemory(Docker.convertBytes(runContext.render(this.getMemory().getKernelMemory())));
            }
            if (this.getMemory().getOomKillDisable() != null) {
                hostConfig.withOomKillDisable(this.getMemory().getOomKillDisable());
            }
        }
        if (this.getShmSize() != null) {
            hostConfig.withShmSize(Docker.convertBytes(runContext.render(this.getShmSize())));
        }
        if (this.getNetworkMode() != null) {
            hostConfig.withNetworkMode(runContext.render(this.getNetworkMode(), additionalVars));
        }
        return container.withHostConfig(hostConfig).withCmd(taskCommands.getCommands()).withAttachStderr(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true));
    }

    private static Long convertBytes(String bytes) {
        return ((Number)READABLE_BYTES_TYPE_CONVERTER.convert((Object)bytes, Number.class).orElseThrow(() -> new IllegalArgumentException("Invalid size with value '" + bytes + "'"))).longValue();
    }

    private void pullImage(DockerClient dockerClient, String image, PullPolicy policy, Logger logger) {
        NameParser.ReposTag imageParse = NameParser.parseRepositoryTag((String)image);
        if (policy.equals((Object)PullPolicy.IF_NOT_PRESENT)) {
            try {
                dockerClient.inspectImageCmd(image).exec();
                return;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        try (PullImageCmd pull = dockerClient.pullImageCmd(image);){
            new RetryUtils().of((AbstractRetry)((Exponential.ExponentialBuilder)Exponential.builder().delayFactor(Double.valueOf(2.0)).interval(Duration.ofSeconds(5L)).maxInterval(Duration.ofSeconds(120L)).maxAttempt(Integer.valueOf(5))).build()).run((bool, throwable) -> throwable instanceof InternalServerErrorException || throwable.getCause() instanceof ConnectionClosedException, () -> {
                String tag = !imageParse.tag.isEmpty() ? imageParse.tag : "latest";
                String repository = pull.getRepository().contains(":") ? pull.getRepository().split(":")[0] : pull.getRepository();
                ((PullImageResultCallback)pull.withTag(tag).exec((ResultCallback)new PullImageResultCallback())).awaitCompletion();
                if (logger.isTraceEnabled()) {
                    logger.trace("Image pulled [{}:{}]", (Object)repository, (Object)tag);
                }
                return true;
            });
        }
    }

    @Generated
    private static List<String> $default$entryPoint() {
        return List.of("");
    }

    @Generated
    private static PullPolicy $default$pullPolicy() {
        return PullPolicy.ALWAYS;
    }

    @Generated
    private static FileHandlingStrategy $default$fileHandlingStrategy() {
        return FileHandlingStrategy.VOLUME;
    }

    @Generated
    private static Boolean $default$delete() {
        return true;
    }

    @Generated
    protected Docker(DockerBuilder<?, ?> b) {
        super(b);
        this.host = b.host;
        this.config = b.config;
        this.credentials = b.credentials;
        this.image = b.image;
        this.user = b.user;
        this.entryPoint = b.entryPoint$set ? b.entryPoint$value : Docker.$default$entryPoint();
        this.extraHosts = b.extraHosts;
        this.networkMode = b.networkMode;
        this.volumes = b.volumes;
        this.pullPolicy = b.pullPolicy$set ? b.pullPolicy$value : Docker.$default$pullPolicy();
        this.deviceRequests = b.deviceRequests;
        this.cpu = b.cpu;
        this.memory = b.memory;
        this.shmSize = b.shmSize;
        this.fileHandlingStrategy = b.fileHandlingStrategy$set ? b.fileHandlingStrategy$value : Docker.$default$fileHandlingStrategy();
        this.delete = b.delete$set ? b.delete$value : Docker.$default$delete();
    }

    @Generated
    public static DockerBuilder<?, ?> builder() {
        return new DockerBuilderImpl();
    }

    @Generated
    public DockerBuilder<?, ?> toBuilder() {
        return new DockerBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String toString() {
        return "Docker(super=" + super.toString() + ", host=" + this.getHost() + ", config=" + String.valueOf(this.getConfig()) + ", credentials=" + String.valueOf(this.getCredentials()) + ", image=" + this.getImage() + ", user=" + this.getUser() + ", entryPoint=" + String.valueOf(this.getEntryPoint()) + ", extraHosts=" + String.valueOf(this.getExtraHosts()) + ", networkMode=" + this.getNetworkMode() + ", volumes=" + String.valueOf(this.getVolumes()) + ", pullPolicy=" + String.valueOf((Object)this.getPullPolicy()) + ", deviceRequests=" + String.valueOf(this.getDeviceRequests()) + ", cpu=" + String.valueOf(this.getCpu()) + ", memory=" + String.valueOf(this.getMemory()) + ", shmSize=" + this.getShmSize() + ", fileHandlingStrategy=" + String.valueOf((Object)this.getFileHandlingStrategy()) + ", delete=" + this.getDelete() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Docker)) {
            return false;
        }
        Docker other = (Docker)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$delete = this.getDelete();
        Boolean other$delete = other.getDelete();
        if (this$delete == null ? other$delete != null : !((Object)this$delete).equals(other$delete)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Object this$config = this.getConfig();
        Object other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        Credentials this$credentials = this.getCredentials();
        Credentials other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        List<String> this$entryPoint = this.getEntryPoint();
        List<String> other$entryPoint = other.getEntryPoint();
        if (this$entryPoint == null ? other$entryPoint != null : !((Object)this$entryPoint).equals(other$entryPoint)) {
            return false;
        }
        List<String> this$extraHosts = this.getExtraHosts();
        List<String> other$extraHosts = other.getExtraHosts();
        if (this$extraHosts == null ? other$extraHosts != null : !((Object)this$extraHosts).equals(other$extraHosts)) {
            return false;
        }
        String this$networkMode = this.getNetworkMode();
        String other$networkMode = other.getNetworkMode();
        if (this$networkMode == null ? other$networkMode != null : !this$networkMode.equals(other$networkMode)) {
            return false;
        }
        List<String> this$volumes = this.getVolumes();
        List<String> other$volumes = other.getVolumes();
        if (this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes)) {
            return false;
        }
        PullPolicy this$pullPolicy = this.getPullPolicy();
        PullPolicy other$pullPolicy = other.getPullPolicy();
        if (this$pullPolicy == null ? other$pullPolicy != null : !((Object)((Object)this$pullPolicy)).equals((Object)other$pullPolicy)) {
            return false;
        }
        List<DeviceRequest> this$deviceRequests = this.getDeviceRequests();
        List<DeviceRequest> other$deviceRequests = other.getDeviceRequests();
        if (this$deviceRequests == null ? other$deviceRequests != null : !((Object)this$deviceRequests).equals(other$deviceRequests)) {
            return false;
        }
        Cpu this$cpu = this.getCpu();
        Cpu other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !this$cpu.equals(other$cpu)) {
            return false;
        }
        Memory this$memory = this.getMemory();
        Memory other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !this$memory.equals(other$memory)) {
            return false;
        }
        String this$shmSize = this.getShmSize();
        String other$shmSize = other.getShmSize();
        if (this$shmSize == null ? other$shmSize != null : !this$shmSize.equals(other$shmSize)) {
            return false;
        }
        FileHandlingStrategy this$fileHandlingStrategy = this.getFileHandlingStrategy();
        FileHandlingStrategy other$fileHandlingStrategy = other.getFileHandlingStrategy();
        return !(this$fileHandlingStrategy == null ? other$fileHandlingStrategy != null : !((Object)((Object)this$fileHandlingStrategy)).equals((Object)other$fileHandlingStrategy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Docker;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $delete = this.getDelete();
        result = result * 59 + ($delete == null ? 43 : ((Object)$delete).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Object $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        Credentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        List<String> $entryPoint = this.getEntryPoint();
        result = result * 59 + ($entryPoint == null ? 43 : ((Object)$entryPoint).hashCode());
        List<String> $extraHosts = this.getExtraHosts();
        result = result * 59 + ($extraHosts == null ? 43 : ((Object)$extraHosts).hashCode());
        String $networkMode = this.getNetworkMode();
        result = result * 59 + ($networkMode == null ? 43 : $networkMode.hashCode());
        List<String> $volumes = this.getVolumes();
        result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
        PullPolicy $pullPolicy = this.getPullPolicy();
        result = result * 59 + ($pullPolicy == null ? 43 : ((Object)((Object)$pullPolicy)).hashCode());
        List<DeviceRequest> $deviceRequests = this.getDeviceRequests();
        result = result * 59 + ($deviceRequests == null ? 43 : ((Object)$deviceRequests).hashCode());
        Cpu $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : $cpu.hashCode());
        Memory $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : $memory.hashCode());
        String $shmSize = this.getShmSize();
        result = result * 59 + ($shmSize == null ? 43 : $shmSize.hashCode());
        FileHandlingStrategy $fileHandlingStrategy = this.getFileHandlingStrategy();
        result = result * 59 + ($fileHandlingStrategy == null ? 43 : ((Object)((Object)$fileHandlingStrategy)).hashCode());
        return result;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Object getConfig() {
        return this.config;
    }

    @Generated
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public List<String> getEntryPoint() {
        return this.entryPoint;
    }

    @Generated
    public List<String> getExtraHosts() {
        return this.extraHosts;
    }

    @Generated
    public String getNetworkMode() {
        return this.networkMode;
    }

    @Generated
    public List<String> getVolumes() {
        return this.volumes;
    }

    @Generated
    public PullPolicy getPullPolicy() {
        return this.pullPolicy;
    }

    @Generated
    public List<DeviceRequest> getDeviceRequests() {
        return this.deviceRequests;
    }

    @Generated
    public Cpu getCpu() {
        return this.cpu;
    }

    @Generated
    public Memory getMemory() {
        return this.memory;
    }

    @Generated
    public String getShmSize() {
        return this.shmSize;
    }

    @Generated
    public FileHandlingStrategy getFileHandlingStrategy() {
        return this.fileHandlingStrategy;
    }

    @Generated
    public Boolean getDelete() {
        return this.delete;
    }

    @Generated
    public Docker() {
        this.entryPoint = Docker.$default$entryPoint();
        this.pullPolicy = Docker.$default$pullPolicy();
        this.fileHandlingStrategy = Docker.$default$fileHandlingStrategy();
        this.delete = Docker.$default$delete();
    }

    private /* synthetic */ void lambda$run$0(DockerClient dockerClient, CreateContainerResponse exec, Logger logger) {
        this.kill(dockerClient, exec.getId(), logger);
    }

    @Generated
    public static abstract class DockerBuilder<C extends Docker, B extends DockerBuilder<C, B>>
    extends TaskRunner.TaskRunnerBuilder<C, B> {
        @Generated
        private String host;
        @Generated
        private Object config;
        @Generated
        private Credentials credentials;
        @Generated
        private String image;
        @Generated
        private String user;
        @Generated
        private boolean entryPoint$set;
        @Generated
        private List<String> entryPoint$value;
        @Generated
        private List<String> extraHosts;
        @Generated
        private String networkMode;
        @Generated
        private List<String> volumes;
        @Generated
        private boolean pullPolicy$set;
        @Generated
        private PullPolicy pullPolicy$value;
        @Generated
        private List<DeviceRequest> deviceRequests;
        @Generated
        private Cpu cpu;
        @Generated
        private Memory memory;
        @Generated
        private String shmSize;
        @Generated
        private boolean fileHandlingStrategy$set;
        @Generated
        private FileHandlingStrategy fileHandlingStrategy$value;
        @Generated
        private boolean delete$set;
        @Generated
        private Boolean delete$value;

        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DockerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Docker instance, DockerBuilder<?, ?> b) {
            b.host(instance.host);
            b.config(instance.config);
            b.credentials(instance.credentials);
            b.image(instance.image);
            b.user(instance.user);
            b.entryPoint(instance.entryPoint);
            b.extraHosts(instance.extraHosts);
            b.networkMode(instance.networkMode);
            b.volumes(instance.volumes);
            b.pullPolicy(instance.pullPolicy);
            b.deviceRequests(instance.deviceRequests);
            b.cpu(instance.cpu);
            b.memory(instance.memory);
            b.shmSize(instance.shmSize);
            b.fileHandlingStrategy(instance.fileHandlingStrategy);
            b.delete(instance.delete);
        }

        @Generated
        public B host(String host) {
            this.host = host;
            return (B)this.self();
        }

        @Generated
        public B config(Object config) {
            this.config = config;
            return (B)this.self();
        }

        @Generated
        public B credentials(Credentials credentials) {
            this.credentials = credentials;
            return (B)this.self();
        }

        @Generated
        public B image(String image) {
            this.image = image;
            return (B)this.self();
        }

        @Generated
        public B user(String user) {
            this.user = user;
            return (B)this.self();
        }

        @Generated
        public B entryPoint(List<String> entryPoint) {
            this.entryPoint$value = entryPoint;
            this.entryPoint$set = true;
            return (B)this.self();
        }

        @Generated
        public B extraHosts(List<String> extraHosts) {
            this.extraHosts = extraHosts;
            return (B)this.self();
        }

        @Generated
        public B networkMode(String networkMode) {
            this.networkMode = networkMode;
            return (B)this.self();
        }

        @Generated
        public B volumes(List<String> volumes) {
            this.volumes = volumes;
            return (B)this.self();
        }

        @Generated
        public B pullPolicy(PullPolicy pullPolicy) {
            this.pullPolicy$value = pullPolicy;
            this.pullPolicy$set = true;
            return (B)this.self();
        }

        @Generated
        public B deviceRequests(List<DeviceRequest> deviceRequests) {
            this.deviceRequests = deviceRequests;
            return (B)this.self();
        }

        @Generated
        public B cpu(Cpu cpu) {
            this.cpu = cpu;
            return (B)this.self();
        }

        @Generated
        public B memory(Memory memory) {
            this.memory = memory;
            return (B)this.self();
        }

        @Generated
        public B shmSize(String shmSize) {
            this.shmSize = shmSize;
            return (B)this.self();
        }

        @Generated
        public B fileHandlingStrategy(FileHandlingStrategy fileHandlingStrategy) {
            this.fileHandlingStrategy$value = fileHandlingStrategy;
            this.fileHandlingStrategy$set = true;
            return (B)this.self();
        }

        @Generated
        public B delete(Boolean delete) {
            this.delete$value = delete;
            this.delete$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Docker.DockerBuilder(super=" + super.toString() + ", host=" + this.host + ", config=" + String.valueOf(this.config) + ", credentials=" + String.valueOf(this.credentials) + ", image=" + this.image + ", user=" + this.user + ", entryPoint$value=" + String.valueOf(this.entryPoint$value) + ", extraHosts=" + String.valueOf(this.extraHosts) + ", networkMode=" + this.networkMode + ", volumes=" + String.valueOf(this.volumes) + ", pullPolicy$value=" + String.valueOf((Object)this.pullPolicy$value) + ", deviceRequests=" + String.valueOf(this.deviceRequests) + ", cpu=" + String.valueOf(this.cpu) + ", memory=" + String.valueOf(this.memory) + ", shmSize=" + this.shmSize + ", fileHandlingStrategy$value=" + String.valueOf((Object)this.fileHandlingStrategy$value) + ", delete$value=" + this.delete$value + ")";
        }
    }

    public static enum FileHandlingStrategy {
        MOUNT,
        VOLUME;

    }

    @Generated
    private static final class DockerBuilderImpl
    extends DockerBuilder<Docker, DockerBuilderImpl> {
        @Generated
        private DockerBuilderImpl() {
        }

        @Override
        @Generated
        protected DockerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Docker build() {
            return new Docker(this);
        }
    }
}

