package io.kestros.commons.validation.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kestros.commons.structuredslingmodels.BaseSlingModel;
import io.kestros.commons.validation.ModelValidationMessageType;

/**
 * Base interface for Model Validation rules.
 */
public abstract class ModelValidator<T extends BaseSlingModel> {

  private BaseSlingModel model;
  private Boolean processed = false;
  private Boolean valid = false;

  @JsonIgnore
  public T getModel() {
    return (T) this.model;
  }

  public void setModel(T model) {
    this.model = model;
  }

  public void validate() {
    this.setValid(this.isValidCheck());
    this.setProcessed(true);
  }

  @JsonIgnore
  public boolean isProcessed() {
    return this.processed;
  }

  protected void setProcessed(Boolean processed) {
    this.processed = processed;
  }

  /**
   * Boolean logic To determine whether the current validator passes validation.
   *
   * @return Whether the current Validator is valid or not.
   */
  @JsonIgnore
  public Boolean isValid() {
    return this.valid;
  }

  protected void setValid(Boolean valid) {
    this.valid = valid;
  }

  @JsonIgnore
  public abstract Boolean isValidCheck();

  /**
   * Message to be shown when the current validator is not valid.
   *
   * @return Message to be shown when the current validator is not valid.
   */
  public abstract String getMessage();

  public abstract String getDetailedMessage();

  /**
   * The error level of the current validator.  Can be ERROR, WARNING or INFO.
   *
   * @return The error level of the current validator.
   */
  public abstract ModelValidationMessageType getType();
}