package io.kestros.commons.validation.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kestros.commons.validation.ModelValidationMessageType;

public class RegisteredModelValidator {

  boolean isActive;
  ModelValidator modelValidator;

  public RegisteredModelValidator(ModelValidator modelValidator, boolean isActive) {
    this.modelValidator = modelValidator;
    this.isActive = isActive;
  }

  public boolean isActive() {
    return this.isActive;
  }

  public void activate() {
    this.isActive = true;
  }

  public void deactivate() {
    this.isActive = false;
  }

  @JsonIgnore
  public ModelValidator getModelValidator() {
    return this.modelValidator;
  }

  public String getTitle() {
    return getModelValidator().getClass().getSimpleName();
  }

  public ModelValidationMessageType getType() {
    return getModelValidator().getType();
  }
}
