package io.kestros.commons.validation.services;

import io.kestros.commons.osgiserviceutils.services.ManagedService;
import io.kestros.commons.structuredslingmodels.BaseResource;
import io.kestros.commons.validation.models.ModelValidator;
import java.util.List;

public interface ModelValidationService extends ManagedService {

  <T extends BaseResource> List<ModelValidator> getProcessedValidators(T model);

  <T extends BaseResource> Integer getErrorsCount(T model);

  <T extends BaseResource> Integer getWarningsCount(T model);

  <T extends BaseResource> List<String> getErrorMessages(T model);

  <T extends BaseResource> List<String> getWarningMessages(T model);
}
