package io.kestros.commons.validation.services;

import io.kestros.commons.osgiserviceutils.services.ManagedService;
import io.kestros.commons.validation.models.ModelValidator;
import io.kestros.commons.validation.models.RegisteredModelValidator;
import java.util.List;

public interface ModelValidatorProviderService extends ManagedService {

  void activateValidator(ModelValidator validator, Class type);

  void deactivateValidator(ModelValidator validator, Class type);

  List<RegisteredModelValidator> getAllValidators(Class type);

  List<RegisteredModelValidator> getActiveValidators(Class type);

  List<RegisteredModelValidator> getInactiveValidators(Class type);
}
