/*
 * Decompiled with CFR 0.152.
 */
package extras.concurrent.testing;

import extras.concurrent.ExecutorServiceOps$;
import extras.concurrent.testing.types;
import extras.concurrent.testing.types$ErrorLogger$;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public interface ConcurrentSupport {
    public static ExecutorService newExecutorService$(ConcurrentSupport $this, int minThread) {
        return $this.newExecutorService(minThread);
    }

    default public ExecutorService newExecutorService(int minThread) {
        if (minThread < 1) {
            throw new IllegalArgumentException("minThread must be greater than or equal to 1. [minThread: " + minThread + "]");
        }
        return Executors.newFixedThreadPool(package$.MODULE$.max(minThread, Runtime.getRuntime().availableProcessors() >> 1));
    }

    public static ExecutionContext newExecutionContext$(ConcurrentSupport $this, ExecutorService executorService, types.ExecutionContextErrorLogger errorLogger) {
        return $this.newExecutionContext(executorService, errorLogger);
    }

    default public ExecutionContext newExecutionContext(ExecutorService executorService, types.ExecutionContextErrorLogger errorLogger) {
        return this.newExecutionContextWithLogger(executorService, errorLogger);
    }

    public static ExecutionContext newExecutionContextWithErrorMessageLogger$(ConcurrentSupport $this, ExecutorService executorService, Function1 errorLogger) {
        return $this.newExecutionContextWithErrorMessageLogger(executorService, (Function1<String, BoxedUnit>)errorLogger);
    }

    default public ExecutionContext newExecutionContextWithErrorMessageLogger(ExecutorService executorService, Function1<String, BoxedUnit> errorLogger) {
        return this.newExecutionContextWithLogger(executorService, types$ErrorLogger$.MODULE$.defaultExecutionContextErrorLogger(errorLogger));
    }

    public static ExecutionContext newExecutionContextWithLogger$(ConcurrentSupport $this, ExecutorService executorService, types.ExecutionContextErrorLogger errorLogger) {
        return $this.newExecutionContextWithLogger(executorService, errorLogger);
    }

    default public ExecutionContext newExecutionContextWithLogger(ExecutorService executorService, types.ExecutionContextErrorLogger errorLogger) {
        return ExecutionContext$.MODULE$.fromExecutor((Executor)executorService, (Function1)errorLogger);
    }

    public static Object runAndShutdown$(ConcurrentSupport $this, ExecutorService executorService, FiniteDuration waitFor, Function0 a, types.ErrorLogger errorLogger) {
        return $this.runAndShutdown(executorService, waitFor, a, errorLogger);
    }

    default public <A> A runAndShutdown(ExecutorService executorService, FiniteDuration waitFor, Function0<A> a, types.ErrorLogger<Throwable> errorLogger) {
        Object object;
        try {
            object = a.apply();
        }
        catch (Throwable throwable) {
            block8: {
                try {
                    ExecutorServiceOps$.MODULE$.shutdownAndAwaitTermination(executorService, waitFor);
                }
                catch (Throwable throwable2) {
                    Option option;
                    Throwable throwable3 = throwable2;
                    if (throwable3 != null && !(option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                        Throwable throwable4;
                        Throwable ex = throwable4 = (Throwable)option.get();
                        errorLogger.apply(ex);
                        break block8;
                    }
                    throw throwable2;
                }
            }
            throw throwable;
        }
        Object object2 = object;
        try {
            ExecutorServiceOps$.MODULE$.shutdownAndAwaitTermination(executorService, waitFor);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable5 = throwable;
            if (throwable5 != null && !(option = NonFatal$.MODULE$.unapply(throwable5)).isEmpty()) {
                Throwable throwable6;
                Throwable ex = throwable6 = (Throwable)option.get();
                errorLogger.apply(ex);
            }
            throw throwable;
        }
        return (A)object2;
    }

    public static Object futureToValue$(ConcurrentSupport $this, Future fa, FiniteDuration waitFor, types.ErrorLogger errorLogger) {
        return $this.futureToValue(fa, waitFor, errorLogger);
    }

    default public <A> A futureToValue(Future<A> fa, FiniteDuration waitFor, types.ErrorLogger<TimeoutException> errorLogger) {
        Object object;
        try {
            object = Await$.MODULE$.result(fa, (Duration)waitFor);
        }
        catch (TimeoutException ex) {
            errorLogger.apply(ex);
            throw ex;
        }
        return (A)object;
    }

    public static Object futureToValueAndTerminate$(ConcurrentSupport $this, ExecutorService executorService, FiniteDuration waitFor, Function0 fa, types.ErrorLogger errorLogger) {
        return $this.futureToValueAndTerminate(executorService, waitFor, fa, errorLogger);
    }

    default public <A> A futureToValueAndTerminate(ExecutorService executorService, FiniteDuration waitFor, Function0<Future<A>> fa, types.ErrorLogger<Throwable> errorLogger) {
        return this.runAndShutdown(executorService, waitFor, () -> this.futureToValueAndTerminate$$anonfun$1(waitFor, fa, errorLogger), errorLogger);
    }

    private Object futureToValueAndTerminate$$anonfun$1(FiniteDuration waitFor$1, Function0 fa$1, types.ErrorLogger errorLogger$1) {
        return this.futureToValue((Future)fa$1.apply(), waitFor$1, errorLogger$1);
    }
}

