/*
 * Decompiled with CFR 0.152.
 */
package extras.hedgehog.circe;

import cats.Show;
import cats.syntax.package;
import extras.hedgehog.circe.RoundTripTester;
import extras.typeinfo.syntax.types;
import extras.typeinfo.syntax.types$;
import hedgehog.core.Log$;
import hedgehog.core.Result;
import hedgehog.package;
import io.circe.Decoder;
import io.circe.Encoder;
import io.circe.Error;
import io.circe.Error$;
import io.circe.Json;
import io.circe.Printer;
import io.circe.Printer$;
import io.circe.parser.package$;
import io.circe.syntax.package;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.api.TypeTags;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class RoundTripTester$ {
    public static RoundTripTester$ MODULE$;

    static {
        new RoundTripTester$();
    }

    public <A> Result roundTripTest(A a, int indent, Encoder<A> evidence$1, Decoder<A> evidence$2, Show<A> evidence$3, TypeTags.WeakTypeTag<A> evidence$4) {
        int n = indent;
        switch (n) {
            case 0: {
                return this.roundTripTest0(a, Printer$.MODULE$.noSpaces(), evidence$1, evidence$2, evidence$3, evidence$4);
            }
            case 2: {
                return this.roundTripTest0(a, Printer$.MODULE$.spaces2(), evidence$1, evidence$2, evidence$3, evidence$4);
            }
            case 4: {
                return this.roundTripTest0(a, Printer$.MODULE$.spaces4(), evidence$1, evidence$2, evidence$3, evidence$4);
            }
        }
        return this.roundTripTest0(a, Printer$.MODULE$.indented(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(indent), Printer$.MODULE$.indented$default$2()), evidence$1, evidence$2, evidence$3, evidence$4);
    }

    private <A> Result roundTripTest0(A a, Printer printer, Encoder<A> evidence$5, Decoder<A> evidence$6, Show<A> evidence$7, TypeTags.WeakTypeTag<A> evidence$8) {
        Object expected = a;
        Json json = package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(a), evidence$5);
        Either either = package$.MODULE$.decode(json.noSpaces(), evidence$6);
        if (either instanceof Right) {
            Right right = (Right)either;
            Object actual = right.value();
            return package.Syntax$.MODULE$.$eq$eq$eq$eq$extension(hedgehog.package$.MODULE$.Syntax(actual), expected).log((Function0 & Serializable & scala.Serializable)() -> Log$.MODULE$.String2Log(MODULE$.failureAfterParseSuccessMessage(actual, a, json, printer, evidence$7, evidence$8)));
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            Error err = (Error)left.value();
            return hedgehog.package$.MODULE$.Result().failure().log((Function0 & Serializable & scala.Serializable)() -> Log$.MODULE$.String2Log(MODULE$.decodeFailureMessage(a, json, err, printer, evidence$7, evidence$8)));
        }
        throw new MatchError((Object)either);
    }

    public <A> String failureAfterParseSuccessMessage(A actual, A input, Json json, Printer printer, Show<A> evidence$9, TypeTags.WeakTypeTag<A> weakTypeTag) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(291).append("Round-trip test for ").append(types.WeakTypeTagSyntax$.MODULE$.nestedTypeName$extension(types$.MODULE$.weakTypeTagSyntax(weakTypeTag))).append(" failed:\n       |  The input ").append(types.WeakTypeTagSyntax$.MODULE$.nestedTypeName$extension(types$.MODULE$.weakTypeTagSyntax(weakTypeTag))).append(" object does not equal to\n       |  the one that was encoded from the input to JSON then decoded to have\n       |  the ").append(types.WeakTypeTagSyntax$.MODULE$.nestedTypeName$extension(types$.MODULE$.weakTypeTagSyntax(weakTypeTag))).append(" type object back.\n       |> ---\n       |> Input: ").append(package.all$.MODULE$.toShow(input, evidence$9).show()).append("\n       |> ---\n       |> Actual: ").append(package.all$.MODULE$.toShow(actual, evidence$9).show()).append("\n       |> ---\n       |> JSON: ").append(json.printWith(printer)).append("\n       |").toString())).stripMargin();
    }

    public <A> String decodeFailureMessage(A a, Json json, Error err, Printer printer, Show<A> evidence$10, TypeTags.WeakTypeTag<A> weakTypeTag) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(130).append("Round-trip test for ").append(types.WeakTypeTagSyntax$.MODULE$.nestedTypeName$extension(types$.MODULE$.weakTypeTagSyntax(weakTypeTag))).append(" failed with error:\n       |> Error: ").append(package.all$.MODULE$.toShow((Object)err, Error$.MODULE$.showError()).show()).append("\n       |> ---\n       |> Input: ").append(package.all$.MODULE$.toShow(a, evidence$10).show()).append("\n       |> ---\n       |> JSON: ").append(json.printWith(printer)).append("\n       |>").toString())).stripMargin();
    }

    public <A> RoundTripTester.Builder<A> apply(A a, Encoder<A> evidence$15, Decoder<A> evidence$16, Show<A> evidence$17, TypeTags.WeakTypeTag<A> evidence$18) {
        return new RoundTripTester.BuilderA<A>(a, 2, evidence$15, evidence$16, evidence$17, evidence$18);
    }

    private RoundTripTester$() {
        MODULE$ = this;
    }
}

