/*
 * Decompiled with CFR 0.152.
 */
package extras.scala.io.truecolor;

import extras.scala.io.truecolor.Rgb;
import extras.scala.io.truecolor.Rgb$RgbOps$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Rgb$ {
    public static final Rgb$ MODULE$ = new Rgb$();
    private static final int RgbBits = 0xFFFFFF;
    private static final int RedBits = 0xFF0000;
    private static final int GreenBits = 65280;
    private static final int BlueBits = 255;

    public int RgbBits() {
        return RgbBits;
    }

    public int RedBits() {
        return RedBits;
    }

    public int GreenBits() {
        return GreenBits;
    }

    public int BlueBits() {
        return BlueBits;
    }

    public Either<String, Rgb> fromInt(int rgb) {
        if (rgb >= 0 && rgb <= this.RgbBits()) {
            return package$.MODULE$.Right().apply((Object)new Rgb(rgb));
        }
        return package$.MODULE$.Left().apply((Object)new StringBuilder(26).append("Invalid RGB color. Input: ").append(Integer.toString(rgb)).toString());
    }

    public Rgb unsafeFromInt(int rgb) {
        return (Rgb)this.fromInt(rgb).fold((Function1 & Serializable)err -> scala.sys.package$.MODULE$.error(err), (Function1 & Serializable)x -> (Rgb)Predef$.MODULE$.identity(x));
    }

    public Either<String, Rgb> fromRgbInts(int red, int green, int blue) {
        boolean blueIsValid;
        boolean redIsValid = red >= 0 && red <= 255;
        boolean greenIsValid = green >= 0 && green <= 255;
        boolean bl = blueIsValid = blue >= 0 && blue <= 255;
        if (redIsValid && greenIsValid && blueIsValid) {
            return package$.MODULE$.Right().apply((Object)new Rgb((red << 16) + (green << 8) + blue));
        }
        List invalidList = (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)redIsValid)).filterNot((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Rgb$.$anonfun$fromRgbInts$1(BoxesRunTime.unboxToBoolean((Object)x)))).map((Function1 & Serializable)x$1 -> Rgb$.$anonfun$fromRgbInts$2(BoxesRunTime.unboxToBoolean((Object)x$1))).toList(), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)greenIsValid)).filterNot((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Rgb$.$anonfun$fromRgbInts$3(BoxesRunTime.unboxToBoolean((Object)x)))).map((Function1 & Serializable)x$2 -> Rgb$.$anonfun$fromRgbInts$4(BoxesRunTime.unboxToBoolean((Object)x$2))).toList(), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)blueIsValid)).filterNot((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Rgb$.$anonfun$fromRgbInts$5(BoxesRunTime.unboxToBoolean((Object)x)))).map((Function1 & Serializable)x$3 -> Rgb$.$anonfun$fromRgbInts$6(BoxesRunTime.unboxToBoolean((Object)x$3))).toList(), (List)Nil$.MODULE$))).flatten(Predef$.MODULE$.$conforms());
        return package$.MODULE$.Left().apply((Object)new StringBuilder(63).append("Invalid RGB color. Invalid: [").append(invalidList.mkString(", ")).append("],").append(" Input: (Red: ").append(Integer.toString(red)).append(", Green: ").append(Integer.toString(green)).append(", Blue: ").append(Integer.toString(blue)).append(")").toString());
    }

    public Rgb unsafeFromRgbInts(int red, int green, int blue) {
        return (Rgb)this.fromRgbInts(red, green, blue).fold((Function1 & Serializable)err -> scala.sys.package$.MODULE$.error(err), (Function1 & Serializable)x -> (Rgb)Predef$.MODULE$.identity(x));
    }

    public Either<String, Rgb> fromHexString(String hex) {
        boolean bl = false;
        Success success = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> StringOps$.MODULE$.sliding$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(hex), "#")), 2, 2).toList().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)Rgb$.$anonfun$fromHexString$2(x$4))));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            return package$.MODULE$.Left().apply((Object)new StringBuilder(28).append("Invalid color hex: ").append(hex).append(", Error: ").append(exception.getMessage()).toString());
        }
        if (try_ instanceof Success) {
            SeqOps seqOps;
            bl = true;
            success = (Success)try_;
            List list = (List)success.value();
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) == 0) {
                int r = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0));
                int g = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1));
                int b = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2));
                return this.fromRgbInts(r, g, b);
            }
        }
        if (bl) {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(19).append("Invalid color hex: ").append(hex).toString());
        }
        throw new MatchError((Object)try_);
    }

    public Rgb unsafeFromHexString(String hex) {
        return (Rgb)this.fromHexString(hex).fold((Function1 & Serializable)err -> scala.sys.package$.MODULE$.error(err), (Function1 & Serializable)x -> (Rgb)Predef$.MODULE$.identity(x));
    }

    public Some<Tuple3<Rgb.Red, Rgb.Green, Rgb.Blue>> unapply(Rgb rgb) {
        return new Some((Object)new Tuple3((Object)new Rgb.Red(Rgb$RgbOps$.MODULE$.red$extension(this.RgbOps(rgb))), (Object)new Rgb.Green(Rgb$RgbOps$.MODULE$.green$extension(this.RgbOps(rgb))), (Object)new Rgb.Blue(Rgb$RgbOps$.MODULE$.blue$extension(this.RgbOps(rgb)))));
    }

    public Rgb RgbOps(Rgb rgb) {
        return rgb;
    }

    public static final /* synthetic */ boolean $anonfun$fromRgbInts$1(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ String $anonfun$fromRgbInts$2(boolean x$1) {
        return "Red";
    }

    public static final /* synthetic */ boolean $anonfun$fromRgbInts$3(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ String $anonfun$fromRgbInts$4(boolean x$2) {
        return "Green";
    }

    public static final /* synthetic */ boolean $anonfun$fromRgbInts$5(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ String $anonfun$fromRgbInts$6(boolean x$3) {
        return "Blue";
    }

    public static final /* synthetic */ int $anonfun$fromHexString$2(String x$4) {
        return Integer.parseInt(x$4, 16);
    }

    private Rgb$() {
    }
}

