/*
 * Decompiled with CFR 0.152.
 */
package extras.scala.io.truecolor;

import extras.scala.io.Color$;
import extras.scala.io.truecolor.Rgb;
import extras.scala.io.truecolor.Rgb$Blue$;
import extras.scala.io.truecolor.Rgb$Green$;
import extras.scala.io.truecolor.Rgb$Red$;
import java.io.Serializable;
import scala.CanEqual;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;
import scala.util.Try$;

public final class Rgb$
implements Serializable {
    private static final int RgbBits;
    private static final int RedBits;
    private static final int GreenBits;
    private static final int BlueBits;
    public static final Rgb$Red$ Red;
    public static final Rgb$Green$ Green;
    public static final Rgb$Blue$ Blue;
    private static CanEqual derived$CanEqual$lzy1;
    private boolean derived$CanEqualbitmap$1;
    public static final Rgb$ MODULE$;

    private Rgb$() {
    }

    static {
        MODULE$ = new Rgb$();
        RgbBits = 0xFFFFFF;
        RedBits = 0xFF0000;
        GreenBits = 65280;
        BlueBits = 255;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Rgb$.class);
    }

    public int RgbBits() {
        return RgbBits;
    }

    public int RedBits() {
        return RedBits;
    }

    public int GreenBits() {
        return GreenBits;
    }

    public int BlueBits() {
        return BlueBits;
    }

    public Either<String, Rgb> fromInt(int rgb2) {
        return rgb2 >= 0 && rgb2 <= this.RgbBits() ? package$.MODULE$.Right().apply((Object)new Rgb(rgb2)) : package$.MODULE$.Left().apply((Object)new StringBuilder(26).append("Invalid RGB color. Input: ").append(BoxesRunTime.boxToInteger((int)rgb2).toString()).toString());
    }

    public Rgb unsafeFromInt(int rgb2) {
        return (Rgb)this.fromInt(rgb2).fold((Function1 & Serializable)err -> {
            throw scala.sys.package$.MODULE$.error(err);
        }, (Function1 & Serializable)x -> (Rgb)Predef$.MODULE$.identity(x));
    }

    public Either<String, Rgb> fromRgbInts(int red, int green, int blue) {
        Right right;
        boolean blueIsValid;
        boolean redIsValid = red >= 0 && red <= 255;
        boolean greenIsValid = green >= 0 && green <= 255;
        boolean bl = blueIsValid = blue >= 0 && blue <= 255;
        if (redIsValid && greenIsValid && blueIsValid) {
            right = package$.MODULE$.Right().apply((Object)new Rgb((red << 16) + (green << 8) + blue));
        } else {
            List invalidList = (List)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)redIsValid)).filterNot((Function1 & Serializable)x -> this.$anonfun$1(BoxesRunTime.unboxToBoolean((Object)x))).map((Function1 & Serializable)_$1 -> this.$anonfun$2(BoxesRunTime.unboxToBoolean((Object)_$1))), Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)greenIsValid)).filterNot((Function1 & Serializable)x -> this.$anonfun$3(BoxesRunTime.unboxToBoolean((Object)x))).map((Function1 & Serializable)_$2 -> this.$anonfun$4(BoxesRunTime.unboxToBoolean((Object)_$2))), Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)blueIsValid)).filterNot((Function1 & Serializable)x -> this.$anonfun$5(BoxesRunTime.unboxToBoolean((Object)x))).map((Function1 & Serializable)_$3 -> this.$anonfun$6(BoxesRunTime.unboxToBoolean((Object)_$3)))}))).flatten(Predef$.MODULE$.$conforms());
            right = package$.MODULE$.Left().apply((Object)new StringBuilder(31).append("Invalid RGB color. Invalid: [").append(invalidList.mkString(", ")).append("],").append(new StringBuilder(32).append(" Input: (Red: ").append(BoxesRunTime.boxToInteger((int)red).toString()).append(", Green: ").append(BoxesRunTime.boxToInteger((int)green).toString()).append(", Blue: ").append(BoxesRunTime.boxToInteger((int)blue).toString()).append(")").toString()).toString());
        }
        return right;
    }

    public Rgb unsafeFromRgbInts(int red, int green, int blue) {
        return (Rgb)this.fromRgbInts(red, green, blue).fold((Function1 & Serializable)err -> {
            throw scala.sys.package$.MODULE$.error(err);
        }, (Function1 & Serializable)x -> (Rgb)Predef$.MODULE$.identity(x));
    }

    public Either<String, Rgb> fromHexString(String hex) {
        return Try$.MODULE$.apply(() -> this.fromHexString$$anonfun$1(hex)).toEither().left().map((Function1 & Serializable)err -> new StringBuilder(28).append("Invalid color hex: ").append(hex).append(", Error: ").append(err.getMessage()).toString()).flatMap((Function1 & Serializable)x$1 -> {
            Either<String, Rgb> either;
            SeqOps seqOps;
            List list = x$1;
            if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list), 3) == 0) {
                int n = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0));
                int n2 = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1));
                int n3 = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 2));
                int r = n;
                int g = n2;
                int b = n3;
                either = this.fromRgbInts(r, g, b);
            } else {
                either = package$.MODULE$.Left().apply((Object)new StringBuilder(19).append("Invalid color hex: ").append(hex).toString());
            }
            return either;
        });
    }

    public Rgb unsafeFromHexString(String hex) {
        return (Rgb)this.fromHexString(hex).fold((Function1 & Serializable)err -> {
            throw scala.sys.package$.MODULE$.error(err);
        }, (Function1 & Serializable)x -> (Rgb)Predef$.MODULE$.identity(x));
    }

    public Option<Tuple3<Object, Object, Object>> unapply(Rgb rgb2) {
        return Some$.MODULE$.apply((Object)Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.red(rgb2)), (Object)BoxesRunTime.boxToInteger((int)this.green(rgb2)), (Object)BoxesRunTime.boxToInteger((int)this.blue(rgb2))));
    }

    public int red(Rgb rgb2) {
        return Rgb$Red$.MODULE$.apply((rgb2.value() & this.RedBits()) >> 16);
    }

    public int green(Rgb rgb2) {
        return Rgb$Green$.MODULE$.apply((rgb2.value() & this.GreenBits()) >> 8);
    }

    public int blue(Rgb rgb2) {
        return Rgb$Blue$.MODULE$.apply(rgb2.value() & this.BlueBits());
    }

    private int toValidHex(Rgb rgb2, int n) {
        return n < 0 ? 0 : (n > 255 ? 255 : n);
    }

    public Rgb red(Rgb rgb2, int value) {
        int onlyValidBits = this.toValidHex(rgb2, value) << 16 & this.RedBits();
        int gb = rgb2.value() & this.GreenBits() + this.BlueBits();
        return this.unsafeFromInt(onlyValidBits + gb);
    }

    public Rgb green(Rgb rgb2, int value) {
        int onlyValidBits = this.toValidHex(rgb2, value) << 8 & this.GreenBits();
        int rb = rgb2.value() & this.RedBits() + this.BlueBits();
        return this.unsafeFromInt(onlyValidBits + rb);
    }

    public Rgb blue(Rgb rgb2, int value) {
        int onlyValidBits = this.toValidHex(rgb2, value) & this.BlueBits();
        int rg = rgb2.value() & this.RedBits() + this.GreenBits();
        return this.unsafeFromInt(onlyValidBits + rg);
    }

    public String toHex(Rgb rgb2) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%06x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rgb2.value())}));
    }

    public String toHexHtml(Rgb rgb2) {
        return new StringBuilder(1).append("#").append(this.toHex(rgb2)).toString();
    }

    public Tuple3<Object, Object, Object> toRgbInts(Rgb rgb2) {
        return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Rgb$Red$.MODULE$.value(this.red(rgb2))), (Object)BoxesRunTime.boxToInteger((int)Rgb$Green$.MODULE$.value(this.green(rgb2))), (Object)BoxesRunTime.boxToInteger((int)Rgb$Blue$.MODULE$.value(this.blue(rgb2))));
    }

    public String toAsciiEsc(Rgb rgb2) {
        return new StringBuilder(10).append("\u001b[38;2;").append(BoxesRunTime.boxToInteger((int)Rgb$Red$.MODULE$.value(this.red(rgb2))).toString()).append(";").append(BoxesRunTime.boxToInteger((int)Rgb$Green$.MODULE$.value(this.green(rgb2))).toString()).append(";").append(BoxesRunTime.boxToInteger((int)Rgb$Blue$.MODULE$.value(this.blue(rgb2))).toString()).append("m").toString();
    }

    public String color(Rgb rgb2, String s) {
        return s.isEmpty() ? "" : new StringBuilder(0).append(this.toAsciiEsc(rgb2)).append(s).toString();
    }

    public String colored(Rgb rgb2, String s) {
        return s.isEmpty() ? "" : new StringBuilder(0).append(this.toAsciiEsc(rgb2)).append(s).append(Color$.MODULE$.toAnsi(Color$.Reset)).toString();
    }

    public CanEqual<Rgb, Rgb> derived$CanEqual() {
        if (!this.derived$CanEqualbitmap$1) {
            derived$CanEqual$lzy1 = CanEqual.derived$.MODULE$;
            this.derived$CanEqualbitmap$1 = true;
        }
        return derived$CanEqual$lzy1;
    }

    private final /* synthetic */ boolean $anonfun$1(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    private final /* synthetic */ String $anonfun$2(boolean _$1) {
        return "Red";
    }

    private final /* synthetic */ boolean $anonfun$3(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    private final /* synthetic */ String $anonfun$4(boolean _$2) {
        return "Green";
    }

    private final /* synthetic */ boolean $anonfun$5(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    private final /* synthetic */ String $anonfun$6(boolean _$3) {
        return "Blue";
    }

    private final List fromHexString$$anonfun$1(String hex$1) {
        return StringOps$.MODULE$.sliding$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(hex$1), "#")), 2, 2).toList().map((Function1 & Serializable)_$4 -> Integer.parseInt(_$4, 16));
    }
}

