/*
 * Decompiled with CFR 0.152.
 */
package io.kgraph.rest.server.graph;

import io.kgraph.GraphAlgorithmState;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.stream.Collectors;

public class GraphAlgorithmStatus {
    private GraphAlgorithmState.State state;
    private int superstep;
    private long runningTime;
    private Map<String, String> aggregates;

    public GraphAlgorithmStatus(GraphAlgorithmState<?> state) {
        this.state = state.state();
        this.superstep = state.superstep();
        this.runningTime = state.runningTime();
        this.aggregates = state.aggregates().entrySet().stream().filter(e -> !((String)e.getKey()).equals("last.written.offsets")).collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
    }

    @ConstructorProperties(value={"state", "superstep", "runningTime", "aggregates"})
    public GraphAlgorithmStatus(GraphAlgorithmState.State state, int superstep, long runningTime, Map<String, String> aggregates) {
        this.state = state;
        this.superstep = superstep;
        this.runningTime = runningTime;
        this.aggregates = aggregates;
    }

    public GraphAlgorithmState.State getState() {
        return this.state;
    }

    public int getSuperstep() {
        return this.superstep;
    }

    public long getRunningTime() {
        return this.runningTime;
    }

    public Map<String, String> getAggregates() {
        return this.aggregates;
    }

    public void setState(GraphAlgorithmState.State state) {
        this.state = state;
    }

    public void setSuperstep(int superstep) {
        this.superstep = superstep;
    }

    public void setRunningTime(long runningTime) {
        this.runningTime = runningTime;
    }

    public void setAggregates(Map<String, String> aggregates) {
        this.aggregates = aggregates;
    }
}

