/*
 * Decompiled with CFR 0.152.
 */
package io.kinoplan.utils.play.error;

import io.kinoplan.utils.play.request.RequestMapContext$;
import io.kinoplan.utils.scala.logging.Loggable;
import io.kinoplan.utils.scala.logging.Logger;
import io.kinoplan.utils.scala.logging.context.MapContext;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.UsefulException;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpErrorHandlerExceptions$;
import play.api.http.Writeable$;
import play.api.mvc.Codec$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results;
import play.api.mvc.Results$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001B\u0006\r\u0001]A\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\u0006g\u0001!\t\u0001\u000e\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0011\u0019\t\u0006\u0001)A\u0005\u0007\"9!\u000b\u0001b\u0001\n\u0013\u0019\u0006BB,\u0001A\u0003%A\u000bC\u0003Y\u0001\u0011\u0005\u0011\fC\u0003s\u0001\u0011\u00051\u000fC\u0004\u0002\u0002\u0001!I!a\u0001\t\u000f\u0005m\u0001\u0001\"\u0003\u0002\u001e\taQI\u001d:pe\"\u000bg\u000e\u001a7fe*\u0011QBD\u0001\u0006KJ\u0014xN\u001d\u0006\u0003\u001fA\tA\u0001\u001d7bs*\u0011\u0011CE\u0001\u0006kRLGn\u001d\u0006\u0003'Q\t\u0001b[5o_Bd\u0017M\u001c\u0006\u0002+\u0005\u0011\u0011n\\\u0002\u0001'\u0011\u0001\u0001DH\u0014\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\tyR%D\u0001!\u0015\t\t#%\u0001\u0003iiR\u0004(BA\u0012%\u0003\r\t\u0007/\u001b\u0006\u0002\u001f%\u0011a\u0005\t\u0002\u0011\u0011R$\b/\u0012:s_JD\u0015M\u001c3mKJ\u0004\"\u0001\u000b\u0017\u000e\u0003%R!AK\u0016\u0002\u000f1|wmZ5oO*\u00111\u0004E\u0005\u0003[%\u0012\u0001\u0002T8hO\u0006\u0014G.Z\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005A\nT\"\u0001\u0012\n\u0005I\u0012#!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003k]\u0002\"A\u000e\u0001\u000e\u00031AQA\f\u0002A\u0002=B#AA\u001d\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014AB5oU\u0016\u001cGOC\u0001?\u0003\u0015Q\u0017M^1y\u0013\t\u00015H\u0001\u0004J]*,7\r^\u0001\u0005[>$W-F\u0001D!\rIBIR\u0005\u0003\u000bj\u0011aa\u00149uS>t\u0007CA$O\u001d\tAE\n\u0005\u0002J55\t!J\u0003\u0002L-\u00051AH]8pizJ!!\u0014\u000e\u0002\rA\u0013X\rZ3g\u0013\ty\u0005K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001bj\tQ!\\8eK\u0002\na![:Qe>$W#\u0001+\u0011\u0005e)\u0016B\u0001,\u001b\u0005\u001d\u0011un\u001c7fC:\fq![:Qe>$\u0007%A\u0007p]\u000ec\u0017.\u001a8u\u000bJ\u0014xN\u001d\u000b\u00055\u001a\\\u0007\u000fE\u0002\\=\u0002l\u0011\u0001\u0018\u0006\u0003;j\t!bY8oGV\u0014(/\u001a8u\u0013\tyFL\u0001\u0004GkR,(/\u001a\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\n\n1!\u001c<d\u0013\t)'M\u0001\u0004SKN,H\u000e\u001e\u0005\u0006O\u001e\u0001\r\u0001[\u0001\be\u0016\fX/Z:u!\t\t\u0017.\u0003\u0002kE\ni!+Z9vKN$\b*Z1eKJDQ\u0001\\\u0004A\u00025\f!b\u001d;biV\u001c8i\u001c3f!\tIb.\u0003\u0002p5\t\u0019\u0011J\u001c;\t\u000fE<\u0001\u0013!a\u0001\r\u00069Q.Z:tC\u001e,\u0017!D8o'\u0016\u0014h/\u001a:FeJ|'\u000fF\u0002[iVDQa\u001a\u0005A\u0002!DQA\u001e\u0005A\u0002]\f\u0011\"\u001a=dKB$\u0018n\u001c8\u0011\u0005alhBA=|\u001d\tI%0C\u0001\u001c\u0013\ta($A\u0004qC\u000e\\\u0017mZ3\n\u0005y|(!\u0003+ie><\u0018M\u00197f\u0015\ta($A\u0007qkRl\u0015\r]\"p]R,\u0007\u0010\u001e\u000b\u0005\u0003\u000b\t9\u0002\u0006\u0003\u0002\b\u0005M\u0001\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055\u0011&A\u0004d_:$X\r\u001f;\n\t\u0005E\u00111\u0002\u0002\u000b\u001b\u0006\u00048i\u001c8uKb$\bbBA\u000b\u0013\u0001\u000f\u0011qA\u0001\u000b[\u0006\u00048i\u001c8uKb$\bBBA\r\u0013\u0001\u0007\u0001-\u0001\u0004sKN,H\u000e^\u0001\u000fY><7+\u001a:wKJ,%O]8s)\u0019\ty\"!\u000b\u0002,Q!\u0011\u0011EA\u0014!\rI\u00121E\u0005\u0004\u0003KQ\"\u0001B+oSRDq!!\u0006\u000b\u0001\b\t9\u0001C\u0003h\u0015\u0001\u0007\u0001\u000eC\u0004\u0002.)\u0001\r!a\f\u0002\u001fU\u001cXMZ;m\u000bb\u001cW\r\u001d;j_:\u00042\u0001MA\u0019\u0013\r\t\u0019D\t\u0002\u0010+N,g-\u001e7Fq\u000e,\u0007\u000f^5p]\"\u001a\u0001!a\u000e\u0011\u0007i\nI$C\u0002\u0002<m\u0012\u0011bU5oO2,Go\u001c8")
public class ErrorHandler
implements HttpErrorHandler,
Loggable {
    private final Option<String> mode;
    private final boolean isProd;
    private Logger logger;

    public <T> Loggable.TryOps<T> TryOps(Try<T> t) {
        return Loggable.TryOps$((Loggable)this, t);
    }

    public <T> Loggable.FutureOps<T> FutureOps(Future<T> f) {
        return Loggable.FutureOps$((Loggable)this, f);
    }

    public String onClientError$default$3() {
        return HttpErrorHandler.onClientError$default$3$((HttpErrorHandler)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void io$kinoplan$utils$scala$logging$Loggable$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Option<String> mode() {
        return this.mode;
    }

    private boolean isProd() {
        return this.isProd;
    }

    public Future<Result> onClientError(RequestHeader request, int statusCode, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.Status(statusCode).apply((Object)message, Writeable$.MODULE$.wString(Codec$.MODULE$.utf_8())));
    }

    public Future<Result> onServerError(RequestHeader request, Throwable exception) {
        MapContext mapContext = RequestMapContext$.MODULE$.extractMapContext(request);
        return (Future)Try$.MODULE$.apply((Function0 & Serializable)() -> {
            UsefulException usefulException = HttpErrorHandlerExceptions$.MODULE$.throwableToUsefulException((Option)None$.MODULE$, this.isProd(), exception);
            Results.Status result = this.isProd() ? Results$.MODULE$.InternalServerError() : Results$.MODULE$.InternalServerError().apply((Object)new StringBuilder(25).append("A server error occurred: ").append(exception.getMessage()).toString(), Writeable$.MODULE$.wString(Codec$.MODULE$.utf_8()));
            this.putMapContext((Result)result, mapContext);
            this.logServerError(request, usefulException, mapContext);
            return result;
        }).fold((Function1 & Serializable)ex -> {
            Results.Status result = Results$.MODULE$.InternalServerError();
            this.putMapContext((Result)result, mapContext);
            this.logger().error("Error while handling error", ex, mapContext);
            return Future$.MODULE$.successful((Object)result);
        }, (Function1 & Serializable)result -> Future$.MODULE$.successful(result));
    }

    private MapContext putMapContext(Result result, MapContext mapContext) {
        return mapContext.put((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"response_status"), (Object)BoxesRunTime.boxToLong((long)result.header().status())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"response_length"), result.body().contentLength().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))}));
    }

    private void logServerError(RequestHeader request, UsefulException usefulException, MapContext mapContext) {
        this.logger().error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |\n      |! @%s - Internal server error, for (%s) [%s] ->\n      | "))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{usefulException.id, request.method(), request.uri()})), (Throwable)usefulException, mapContext);
    }

    @Inject
    public ErrorHandler(Configuration configuration) {
        Loggable.$init$((Loggable)this);
        this.mode = configuration.getOptional("application.mode", ConfigLoader$.MODULE$.stringLoader()).map((Function1 & Serializable)x$1 -> x$1.toLowerCase());
        this.isProd = this.mode().contains((Object)"prod");
        Statics.releaseFence();
    }
}

