/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.fragments.action.api.log;

import io.knotx.fragments.action.api.log.ActionLog;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;

@DataObject
public class ActionInvocationLog {
    static final String DURATION = "duration";
    static final String SUCCESS = "success";
    static final String DO_ACTION_LOG = "doActionLog";
    private final Long duration;
    private final boolean success;
    private final ActionLog doActionLog;

    private ActionInvocationLog(long duration, boolean success, ActionLog doActionLog) {
        this.duration = duration;
        this.success = success;
        this.doActionLog = doActionLog;
    }

    public ActionInvocationLog(JsonObject json) {
        this.duration = json.getLong(DURATION);
        this.success = json.getBoolean(SUCCESS);
        this.doActionLog = this.toDoActionLog(json);
    }

    static ActionInvocationLog success(long duration, ActionLog actionLog) {
        return new ActionInvocationLog(duration, true, actionLog);
    }

    static ActionInvocationLog error(long duration, ActionLog actionLog) {
        return new ActionInvocationLog(duration, false, actionLog);
    }

    public Long getDuration() {
        return this.duration;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ActionLog getDoActionLog() {
        return this.doActionLog;
    }

    public JsonObject toJson() {
        return new JsonObject().put(DURATION, this.duration).put(SUCCESS, Boolean.valueOf(this.success)).put(DO_ACTION_LOG, this.doActionLog != null ? this.doActionLog.toJson() : null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionInvocationLog that = (ActionInvocationLog)o;
        return this.success == that.success && Objects.equals(this.duration, that.duration) && Objects.equals(this.doActionLog, that.doActionLog);
    }

    public int hashCode() {
        return Objects.hash(this.duration, this.success, this.doActionLog);
    }

    public String toString() {
        return "ActionInvocationLog{duration=" + this.duration + ", success=" + this.success + ", doActionLog=" + this.doActionLog + '}';
    }

    private ActionLog toDoActionLog(JsonObject json) {
        return Optional.ofNullable(json).map(j -> j.getJsonObject(DO_ACTION_LOG)).map(ActionLog::new).orElse(null);
    }
}

