/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.fragments.action.api;

import io.knotx.fragments.action.api.Knot;
import io.knotx.fragments.api.FragmentContext;
import io.knotx.fragments.api.FragmentResult;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;

public class KnotVertxEBProxy
implements Knot {
    private Vertx _vertx;
    private String _address;
    private DeliveryOptions _options;
    private boolean closed;

    public KnotVertxEBProxy(Vertx vertx, String address) {
        this(vertx, address, null);
    }

    public KnotVertxEBProxy(Vertx vertx, String address, DeliveryOptions options) {
        this._vertx = vertx;
        this._address = address;
        this._options = options;
        try {
            this._vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void apply(FragmentContext fragmentContext, Handler<AsyncResult<FragmentResult>> result) {
        if (this.closed) {
            result.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        _json.put("fragmentContext", fragmentContext == null ? null : fragmentContext.toJson());
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "apply");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                result.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                result.handle((Object)Future.succeededFuture((Object)(((Message)res.result()).body() == null ? null : new FragmentResult((JsonObject)((Message)res.result()).body()))));
            }
        });
    }
}

