/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.fragments.action.api.log;

import io.knotx.fragments.action.api.log.ActionInvocationLog;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@DataObject
public class ActionLog {
    private final String alias;
    private final JsonObject logs;
    private final List<ActionInvocationLog> doActionLogs;

    public ActionLog(String alias, JsonObject logs, List<ActionInvocationLog> doActionLogs) {
        this.alias = alias;
        this.logs = logs;
        this.doActionLogs = doActionLogs;
    }

    public ActionLog(JsonObject actionLog) {
        this.alias = actionLog.getString("alias");
        this.logs = actionLog.getJsonObject("logs");
        this.doActionLogs = this.toInvocationLogList(actionLog);
    }

    private List<ActionInvocationLog> toInvocationLogList(JsonObject actionLog) {
        Iterable iterable = () -> actionLog.getJsonArray("doActionLogs").iterator();
        return StreamSupport.stream(iterable.spliterator(), false).map(JsonObject::mapFrom).map(ActionInvocationLog::new).collect(Collectors.toList());
    }

    public String getAlias() {
        return this.alias;
    }

    public JsonObject getLogs() {
        return this.logs.copy();
    }

    public List<ActionInvocationLog> getInvocationLogs() {
        return Collections.unmodifiableList(this.doActionLogs);
    }

    public JsonObject toJson() {
        return new JsonObject().put("alias", this.alias).put("logs", this.getLogs()).put("doActionLogs", this.toDoActionArray());
    }

    public String toString() {
        return "ActionLog{alias='" + this.alias + '\'' + ", log=" + this.logs + ", doActionLogs=" + this.doActionLogs + '}';
    }

    private JsonArray toDoActionArray() {
        return this.getInvocationLogs().stream().map(ActionInvocationLog::toJson).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
    }
}

