/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.fragments.action.api.log;

import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum ActionLogLevel {
    INFO("info"),
    ERROR("error");

    private static final String CONFIG_KEY_NAME = "logLevel";
    private final String level;

    private ActionLogLevel(String level) {
        this.level = level;
    }

    public String getLevel() {
        return this.level;
    }

    public static ActionLogLevel fromConfig(JsonObject config) {
        return ActionLogLevel.fromConfig(config.getString(CONFIG_KEY_NAME, ActionLogLevel.ERROR.level));
    }

    public static ActionLogLevel fromConfig(JsonObject config, ActionLogLevel defaultLevel) {
        String level = config.getString(CONFIG_KEY_NAME);
        return ActionLogLevel.fromConfig(level, defaultLevel);
    }

    public static ActionLogLevel fromConfig(String level, ActionLogLevel defaultLevel) {
        if (StringUtils.isBlank((CharSequence)level)) {
            return defaultLevel;
        }
        return ActionLogLevel.fromConfig(level);
    }

    public static ActionLogLevel fromConfig(String level) {
        return Arrays.stream(ActionLogLevel.values()).filter(al -> Objects.equals(level, al.getLevel())).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Incorrect action log level: %s", level)));
    }
}

