/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.fragments.action.api.log;

import io.knotx.fragments.action.api.log.ActionLog;
import io.knotx.fragments.action.api.log.ActionLogBuilder;
import io.knotx.fragments.action.api.log.ActionLogLevel;
import io.reactivex.exceptions.CompositeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.util.function.Function;

public class ActionLogger {
    private final ActionLogLevel actionLogLevel;
    private final ActionLogBuilder builder;

    private ActionLogger(String alias, ActionLogLevel actionLogLevel) {
        this.actionLogLevel = actionLogLevel;
        this.builder = new ActionLogBuilder(alias);
    }

    public static ActionLogger create(String alias, ActionLogLevel actionLogLevel) {
        return new ActionLogger(alias, actionLogLevel);
    }

    public static ActionLogger create(String alias, String actionLogLevel) {
        ActionLogLevel logLevel = ActionLogLevel.fromConfig(actionLogLevel);
        return new ActionLogger(alias, logLevel);
    }

    public void info(String key, Object data) {
        if (this.actionLogLevel == ActionLogLevel.INFO) {
            if (data instanceof String) {
                this.builder.addLog(key, String.valueOf(data));
                return;
            }
            this.builder.addLog(key, JsonObject.mapFrom((Object)data));
        }
    }

    public void info(String key, String value) {
        if (this.actionLogLevel == ActionLogLevel.INFO) {
            this.builder.addLog(key, value);
        }
    }

    public void info(String key, JsonObject value) {
        if (this.actionLogLevel == ActionLogLevel.INFO) {
            this.builder.addLog(key, value);
        }
    }

    public void info(String key, JsonArray value) {
        if (this.actionLogLevel == ActionLogLevel.INFO) {
            this.builder.addLog(key, value);
        }
    }

    public <T> void info(String key, T value, Function<T, JsonObject> toJsonFunc) {
        if (this.actionLogLevel == ActionLogLevel.INFO) {
            this.builder.addLog(key, toJsonFunc.apply(value));
        }
    }

    public void error(String key, String value) {
        this.builder.addLog(key, value);
    }

    public void error(String key, JsonArray value) {
        this.builder.addLog(key, value);
    }

    public void error(String key, JsonObject value) {
        this.builder.addLog(key, value);
    }

    public void error(Throwable throwable) {
        JsonArray exceptions = new JsonArray();
        if (throwable instanceof CompositeException) {
            ((CompositeException)throwable).getExceptions().forEach(e -> exceptions.add(new JsonObject().put("className", e.getClass().getCanonicalName()).put("message", e.getMessage())));
        } else {
            exceptions.add(new JsonObject().put("className", throwable.getClass().getCanonicalName()).put("message", throwable.getMessage()));
        }
        this.builder.addLog("errors", exceptions);
    }

    public void error(String data) {
        this.builder.addLog(String.valueOf(Instant.now().toEpochMilli()), data);
    }

    public <T> void error(String key, T data, Function<T, JsonObject> toJsonFunc) {
        this.builder.addLog(key, toJsonFunc.apply(data));
    }

    public ActionLog toLog() {
        return this.builder.build();
    }

    public void doActionLog(long duration, JsonObject actionLog) {
        if (this.actionLogLevel == ActionLogLevel.INFO) {
            this.builder.appendInvocationLogEntry(duration, this.toActionLogOrNull(actionLog));
        }
    }

    public void failureDoActionLog(long duration, JsonObject actionLog) {
        this.builder.appendFailureInvocationLogEntry(duration, this.toActionLogOrNull(actionLog));
    }

    private ActionLog toActionLogOrNull(JsonObject jsonObject) {
        return jsonObject != null ? new ActionLog(jsonObject) : null;
    }
}

