/*
 * Copyright (c) 2014 Red Hat, Inc. and others
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.knotx.knot.templating;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;

/**
 * Converter for {@link io.knotx.knot.templating.HandlebarsKnotOptions}.
 *
 * NOTE: This class has been automatically generated from the {@link io.knotx.knot.templating.HandlebarsKnotOptions} original class using Vert.x codegen.
 */
 class HandlebarsKnotOptionsConverter {

   static void fromJson(JsonObject json, HandlebarsKnotOptions obj) {
    if (json.getValue("address") instanceof String) {
      obj.setAddress((String)json.getValue("address"));
    }
    if (json.getValue("cacheKeyAlgorithm") instanceof String) {
      obj.setCacheKeyAlgorithm((String)json.getValue("cacheKeyAlgorithm"));
    }
    if (json.getValue("cacheSize") instanceof Number) {
      obj.setCacheSize(((Number)json.getValue("cacheSize")).longValue());
    }
  }

   static void toJson(HandlebarsKnotOptions obj, JsonObject json) {
    if (obj.getAddress() != null) {
      json.put("address", obj.getAddress());
    }
    if (obj.getCacheKeyAlgorithm() != null) {
      json.put("cacheKeyAlgorithm", obj.getCacheKeyAlgorithm());
    }
    if (obj.getCacheSize() != null) {
      json.put("cacheSize", obj.getCacheSize());
    }
  }
}