/*
 * Copyright (c) 2014 Red Hat, Inc. and others
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.knotx.knot.service;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;

/**
 * Converter for {@link io.knotx.knot.service.ServiceKnotOptions}.
 *
 * NOTE: This class has been automatically generated from the {@link io.knotx.knot.service.ServiceKnotOptions} original class using Vert.x codegen.
 */
 class ServiceKnotOptionsConverter {

   static void fromJson(JsonObject json, ServiceKnotOptions obj) {
    if (json.getValue("address") instanceof String) {
      obj.setAddress((String)json.getValue("address"));
    }
    if (json.getValue("deliveryOptions") instanceof JsonObject) {
      obj.setDeliveryOptions(new io.vertx.core.eventbus.DeliveryOptions((JsonObject)json.getValue("deliveryOptions")));
    }
    if (json.getValue("services") instanceof JsonArray) {
      java.util.ArrayList<io.knotx.knot.service.ServiceMetadata> list = new java.util.ArrayList<>();
      json.getJsonArray("services").forEach( item -> {
        if (item instanceof JsonObject)
          list.add(new io.knotx.knot.service.ServiceMetadata((JsonObject)item));
      });
      obj.setServices(list);
    }
  }

   static void toJson(ServiceKnotOptions obj, JsonObject json) {
    if (obj.getAddress() != null) {
      json.put("address", obj.getAddress());
    }
    if (obj.getDeliveryOptions() != null) {
      json.put("deliveryOptions", obj.getDeliveryOptions().toJson());
    }
    if (obj.getServices() != null) {
      JsonArray array = new JsonArray();
      obj.getServices().forEach(item -> array.add(item.toJson()));
      json.put("services", array);
    }
  }
}