/*
 * Copyright (c) 2014 Red Hat, Inc. and others
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.knotx.knot.service;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;

/**
 * Converter for {@link io.knotx.knot.service.ServiceMetadata}.
 *
 * NOTE: This class has been automatically generated from the {@link io.knotx.knot.service.ServiceMetadata} original class using Vert.x codegen.
 */
 class ServiceMetadataConverter {

   static void fromJson(JsonObject json, ServiceMetadata obj) {
    if (json.getValue("address") instanceof String) {
      obj.setAddress((String)json.getValue("address"));
    }
    if (json.getValue("cacheKey") instanceof String) {
      obj.setCacheKey((String)json.getValue("cacheKey"));
    }
    if (json.getValue("name") instanceof String) {
      obj.setName((String)json.getValue("name"));
    }
    if (json.getValue("params") instanceof JsonObject) {
      obj.setParams(((JsonObject)json.getValue("params")).copy());
    }
  }

   static void toJson(ServiceMetadata obj, JsonObject json) {
    if (obj.getAddress() != null) {
      json.put("address", obj.getAddress());
    }
    if (obj.getCacheKey() != null) {
      json.put("cacheKey", obj.getCacheKey());
    }
    if (obj.getName() != null) {
      json.put("name", obj.getName());
    }
    if (obj.getParams() != null) {
      json.put("params", obj.getParams());
    }
  }
}