/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server;

import io.knotx.server.api.handler.RoutingHandlerFactory;
import io.knotx.server.configuration.RoutingHandlerOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;

class GlobalHandlersProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalHandlersProvider.class);
    private final Vertx vertx;
    private final List<RoutingHandlerOptions> globalHandlers;

    GlobalHandlersProvider(Vertx vertx, List<RoutingHandlerOptions> globalHandlers) {
        this.vertx = vertx;
        this.globalHandlers = globalHandlers;
    }

    void configureGlobalHandlers(OpenAPI3RouterFactory routerFactory) {
        Map<String, RoutingHandlerFactory> factories = this.loadAuthHandlerFactories();
        this.globalHandlers.forEach(handler -> {
            RoutingHandlerFactory factory = (RoutingHandlerFactory)factories.get(handler.getName());
            routerFactory.addGlobalHandler(factory.create(this.vertx, handler.getConfig()));
            LOGGER.info((Object)"Global handler {} registered", new Object[]{handler.getName()});
        });
    }

    private Map<String, RoutingHandlerFactory> loadAuthHandlerFactories() {
        ArrayList routingFactories = new ArrayList();
        ServiceLoader.load(RoutingHandlerFactory.class).iterator().forEachRemaining(routingFactories::add);
        return routingFactories.stream().collect(Collectors.toMap(RoutingHandlerFactory::getName, Function.identity()));
    }
}

