/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server;

import io.knotx.server.configuration.DropRequestOptions;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.SingleSource;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.core.http.HttpServer;
import io.vertx.reactivex.core.http.HttpServerRequest;
import io.vertx.reactivex.ext.web.Router;

class HttpServerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServerProvider.class);
    private final io.vertx.reactivex.core.Vertx vertx;
    private final HttpServerOptions serverOptions;
    private final DropRequestOptions dropRequestOptions;

    HttpServerProvider(io.vertx.reactivex.core.Vertx vertx, HttpServerOptions serverOptions, DropRequestOptions dropRequestOptions) {
        this.vertx = vertx;
        this.serverOptions = serverOptions;
        this.dropRequestOptions = dropRequestOptions;
    }

    SingleSource<? extends HttpServer> configureHttpServer(Router router) {
        HttpServer httpServer = this.vertx.createHttpServer(this.serverOptions);
        if (this.dropRequestOptions.isEnabled()) {
            httpServer.requestStream().toFlowable().map(HttpServerRequest::pause).onBackpressureBuffer(this.dropRequestOptions.getBackpressureBufferCapacity(), () -> LOGGER.warn((Object)"Backpressure buffer is overflown. Dropping request"), this.dropRequestOptions.getBackpressureStrategy()).onBackpressureDrop(req -> req.response().setStatusCode(this.dropRequestOptions.getDropRequestResponseCode()).end()).observeOn(RxHelper.scheduler((Vertx)this.vertx.getDelegate())).subscribe(req -> {
                req.resume();
                this.routeSafe((HttpServerRequest)req, router);
            }, error -> LOGGER.error((Object)"Exception while processing!", error));
        } else {
            httpServer.requestHandler(req -> this.routeSafe((HttpServerRequest)req, router));
        }
        return httpServer.rxListen();
    }

    private void routeSafe(HttpServerRequest req, Router router) {
        try {
            router.handle(req);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn((Object)"Problem decoding Query String ", (Throwable)ex);
            req.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).setStatusMessage(HttpResponseStatus.BAD_REQUEST.reasonPhrase()).end("Invalid characters in Query Parameter");
        }
    }
}

