/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server;

import io.knotx.server.GlobalHandlersProvider;
import io.knotx.server.HttpServerProvider;
import io.knotx.server.RoutesProvider;
import io.knotx.server.SecurityProvider;
import io.knotx.server.configuration.HystrixMetricsOptions;
import io.knotx.server.configuration.KnotxServerOptions;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.circuitbreaker.HystrixMetricHandler;
import io.vertx.reactivex.core.AbstractVerticle;
import io.vertx.reactivex.ext.web.Router;
import io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory;

public class KnotxServerVerticle
extends AbstractVerticle {
    public static final String KNOTX_PORT_PROP_NAME = "knotx.port";
    public static final String KNOTX_FILE_UPLOAD_DIR_PROPERTY = "knotx.fileUploadDir";
    private static final Logger LOGGER = LoggerFactory.getLogger(KnotxServerVerticle.class);
    private KnotxServerOptions options;

    public void init(Vertx vertx, Context context) {
        super.init(vertx, context);
        this.options = new KnotxServerOptions(this.config());
    }

    public void start(Future<Void> fut) {
        LOGGER.info((Object)"Starting <{}>", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        LOGGER.info((Object)"Open API specification location [{}]", new Object[]{this.options.getRoutingSpecificationLocation()});
        GlobalHandlersProvider globalHandlersProvider = new GlobalHandlersProvider(this.vertx, this.options.getGlobalHandlers());
        RoutesProvider routesProvider = new RoutesProvider(this.vertx, this.options.getRoutingOperations());
        SecurityProvider securityProvider = new SecurityProvider(this.vertx, this.options.getSecurityHandlers());
        HttpServerProvider httpServerProvider = new HttpServerProvider(this.vertx, this.options.getServerOptions(), this.options.getDropRequestOptions());
        OpenAPI3RouterFactory.rxCreate((io.vertx.reactivex.core.Vertx)this.vertx, (String)this.options.getRoutingSpecificationLocation()).doOnSuccess(globalHandlersProvider::configureGlobalHandlers).doOnSuccess(securityProvider::configureSecurity).doOnSuccess(routesProvider::configureRouting).doOnSuccess(OpenAPI3RouterFactory::mountServicesFromExtensions).map(OpenAPI3RouterFactory::getRouter).doOnSuccess(this::addHystrixMetrics).doOnSuccess(this::logRouterRoutes).flatMap(httpServerProvider::configureHttpServer).subscribe(ok -> {
            LOGGER.info((Object)"Knot.x HTTP Server started. Listening on port {}", new Object[]{this.options.getServerOptions().getPort()});
            fut.complete();
        }, error -> {
            LOGGER.error((Object)"Unable to start Knot.x HTTP Server.", error.getCause());
            fut.fail(error);
        });
    }

    private void addHystrixMetrics(Router router) {
        HystrixMetricsOptions hystrixMetricsOptions = this.options.getHystrixMetricsOptions();
        if (hystrixMetricsOptions.isEnabled()) {
            router.get(hystrixMetricsOptions.getEndpoint()).handler((Handler)HystrixMetricHandler.create((io.vertx.reactivex.core.Vertx)this.vertx));
        }
    }

    private void logRouterRoutes(Router router) {
        LOGGER.info((Object)"Routes [{}]", new Object[]{router.getRoutes()});
        this.printRoutes(router);
    }

    private void printRoutes(Router router) {
        System.out.println("\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
        System.out.println("@@                              ROUTER CONFIG                                 @@");
        System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
        router.getRoutes().forEach(route -> System.out.println("@@     " + route.getDelegate()));
        System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n");
    }
}

