/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server;

import io.knotx.server.api.handler.RoutingHandlerFactory;
import io.knotx.server.configuration.RoutingOperationOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

class RoutesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutesProvider.class);
    private final Vertx vertx;
    private final List<RoutingOperationOptions> routingOperations;

    RoutesProvider(Vertx vertx, List<RoutingOperationOptions> routingOperations) {
        this.vertx = vertx;
        this.routingOperations = routingOperations;
        this.validateRoutingOperations();
    }

    void configureRouting(OpenAPI3RouterFactory routerFactory) {
        List<RoutingHandlerFactory> handlerFactories = this.loadRoutingHandlerFactories();
        this.routingOperations.forEach(operation -> {
            this.registerRoutingHandlersPerOperation(routerFactory, handlerFactories, (RoutingOperationOptions)operation);
            this.registerFailureHandlersPerOperation(routerFactory, handlerFactories, (RoutingOperationOptions)operation);
            LOGGER.info((Object)"Initialized all handlers for operation [{}]", new Object[]{operation.getOperationId()});
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Operation initialization details [{}]", new Object[]{operation.toJson().encodePrettily()});
            }
        });
    }

    private void validateRoutingOperations() {
        if (this.routingOperations == null || this.routingOperations.isEmpty()) {
            LOGGER.warn((Object)"The server configuration does not contain any operation defined. Please check your configuration [config.server.options.config.routingOperations]");
        }
    }

    private void registerRoutingHandlersPerOperation(OpenAPI3RouterFactory routerFactory, List<RoutingHandlerFactory> handlerFactories, RoutingOperationOptions operation) {
        operation.getHandlers().forEach(routingHandlerOptions -> handlerFactories.stream().filter(handlerFactory -> handlerFactory.getName().equals(routingHandlerOptions.getName())).findAny().map(handlerFactory -> routerFactory.addHandlerByOperationId(operation.getOperationId(), handlerFactory.create(this.vertx, routingHandlerOptions.getConfig()))).orElseThrow(() -> {
            LOGGER.error((Object)"Handler factory [{}] not found in registered factories [{}], all options [{}]", new Object[]{routingHandlerOptions.getName(), handlerFactories, operation});
            return new IllegalStateException("Can not find handler factory for [" + routingHandlerOptions.getName() + "]");
        }));
    }

    private void registerFailureHandlersPerOperation(OpenAPI3RouterFactory openAPI3RouterFactory, List<RoutingHandlerFactory> handlerFactories, RoutingOperationOptions routingOperationOptions) {
        routingOperationOptions.getFailureHandlers().forEach(routingHandlerOptions -> handlerFactories.stream().filter(handlerFactory -> handlerFactory.getName().equals(routingHandlerOptions.getName())).findAny().map(handlerFactory -> openAPI3RouterFactory.addFailureHandlerByOperationId(routingOperationOptions.getOperationId(), handlerFactory.create(this.vertx, routingHandlerOptions.getConfig()))).orElseThrow(IllegalStateException::new));
    }

    private List<RoutingHandlerFactory> loadRoutingHandlerFactories() {
        ArrayList<RoutingHandlerFactory> routingFactories = new ArrayList<RoutingHandlerFactory>();
        ServiceLoader.load(RoutingHandlerFactory.class).iterator().forEachRemaining(routingFactories::add);
        LOGGER.info((Object)"Routing handler factory names [{}] registered.", new Object[]{routingFactories.stream().map(RoutingHandlerFactory::getName).collect(Collectors.joining(","))});
        return routingFactories;
    }
}

