/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server;

import io.knotx.server.api.security.AuthHandlerFactory;
import io.knotx.server.configuration.AuthHandlerOptions;
import io.knotx.server.exceptions.ConfigurationException;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;

class SecurityProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityProvider.class);
    private final Vertx vertx;
    private final List<AuthHandlerOptions> securityHandlers;

    SecurityProvider(Vertx vertx, List<AuthHandlerOptions> securityHandlers) {
        this.vertx = vertx;
        this.securityHandlers = securityHandlers;
    }

    void configureSecurity(OpenAPI3RouterFactory routerFactory) {
        Map<String, AuthHandlerFactory> authHandlerFactoriesByName = this.loadAuthHandlerFactories();
        this.securityHandlers.forEach(options -> {
            this.registerAuthHandler(routerFactory, (AuthHandlerFactory)authHandlerFactoriesByName.get(options.getFactory()), (AuthHandlerOptions)options);
            LOGGER.info((Object)"Security handler [{}] initialized", new Object[]{options.getSchema()});
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Auth handler initialization details [{}]", new Object[]{options.toJson().encodePrettily()});
            }
        });
    }

    private void registerAuthHandler(OpenAPI3RouterFactory routerFactory, AuthHandlerFactory authHandlerFactory, AuthHandlerOptions options) {
        if (routerFactory == null) {
            throw new ConfigurationException("Factory for " + options + " is not registered!");
        }
        routerFactory.addSecurityHandler(options.getSchema(), (Handler)authHandlerFactory.create(this.vertx, options.getConfig()));
    }

    private Map<String, AuthHandlerFactory> loadAuthHandlerFactories() {
        ArrayList routingFactories = new ArrayList();
        ServiceLoader.load(AuthHandlerFactory.class).iterator().forEachRemaining(routingFactories::add);
        LOGGER.info((Object)("Auth handler factory types registered: " + routingFactories.stream().map(AuthHandlerFactory::getName).collect(Collectors.joining(","))));
        return routingFactories.stream().collect(Collectors.toMap(AuthHandlerFactory::getName, Function.identity()));
    }
}

