/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.configuration;

import io.knotx.server.configuration.DropRequestOptionsConverter;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.BackpressureOverflowStrategy;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Map;

@DataObject(generateConverter=true, publicConverter=false)
public class DropRequestOptions {
    private static final boolean DEFAULT_DROP_REQUESTS = false;
    private static final int DEFAULT_DROP_REQUESTS_RESPONSE_CODE = HttpResponseStatus.TOO_MANY_REQUESTS.code();
    private static final long DEFAULT_BACKPRESSURE_BUFFER_SIZE = 1000L;
    private static final BackpressureOverflowStrategy DEFAULT_BACKPRESSURE_STRATEGY = BackpressureOverflowStrategy.DROP_LATEST;
    private boolean enabled;
    private int dropRequestResponseCode;
    private long backpressureBufferCapacity;
    private BackpressureOverflowStrategy backpressureStrategy;

    public DropRequestOptions() {
        this.init();
    }

    public DropRequestOptions(DropRequestOptions other) {
        this.enabled = other.enabled;
        this.dropRequestResponseCode = other.dropRequestResponseCode;
        this.backpressureBufferCapacity = other.backpressureBufferCapacity;
        this.backpressureStrategy = other.backpressureStrategy;
    }

    public DropRequestOptions(JsonObject json) {
        this.init();
        DropRequestOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        DropRequestOptionsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.enabled = false;
        this.dropRequestResponseCode = DEFAULT_DROP_REQUESTS_RESPONSE_CODE;
        this.backpressureBufferCapacity = 1000L;
        this.backpressureStrategy = DEFAULT_BACKPRESSURE_STRATEGY;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DropRequestOptions setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public int getDropRequestResponseCode() {
        return this.dropRequestResponseCode;
    }

    public DropRequestOptions setDropRequestResponseCode(int dropRequestResponseCode) {
        this.dropRequestResponseCode = dropRequestResponseCode;
        return this;
    }

    public long getBackpressureBufferCapacity() {
        return this.backpressureBufferCapacity;
    }

    public DropRequestOptions setBackpressureBufferCapacity(long backpressureBufferCapacity) {
        this.backpressureBufferCapacity = backpressureBufferCapacity;
        return this;
    }

    public BackpressureOverflowStrategy getBackpressureStrategy() {
        return this.backpressureStrategy;
    }

    public DropRequestOptions setBackpressureStrategy(BackpressureOverflowStrategy backpressureStrategy) {
        this.backpressureStrategy = backpressureStrategy;
        return this;
    }
}

