/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.configuration;

import io.knotx.server.configuration.HystrixMetricsOptionsConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Map;

@DataObject(generateConverter=true, publicConverter=false)
public class HystrixMetricsOptions {
    private static final boolean DEFAULT_ENABLE_METRICS = false;
    private static final String DEFAULT_METRICS_ENDPOINT = "/hystrix-metrics";
    private boolean enabled;
    private String endpoint;

    public HystrixMetricsOptions() {
        this.init();
    }

    public HystrixMetricsOptions(JsonObject json) {
        this.init();
        HystrixMetricsOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        HystrixMetricsOptionsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.enabled = false;
        this.endpoint = DEFAULT_METRICS_ENDPOINT;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public HystrixMetricsOptions setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public HystrixMetricsOptions setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String toString() {
        return "HystrixMetricsOptions{enabled=" + this.enabled + ", endpoint='" + this.endpoint + '\'' + '}';
    }
}

