/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.configuration;

import io.knotx.server.configuration.AuthHandlerOptions;
import io.knotx.server.configuration.DropRequestOptions;
import io.knotx.server.configuration.HystrixMetricsOptions;
import io.knotx.server.configuration.KnotxServerOptionsConverter;
import io.knotx.server.configuration.RoutingHandlerOptions;
import io.knotx.server.configuration.RoutingOperationOptions;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true, publicConverter=false)
public class KnotxServerOptions {
    private static final boolean DEFAULT_DISPLAY_EXCEPTIONS = false;
    private boolean displayExceptionDetails;
    private HttpServerOptions serverOptions;
    private String routingSpecificationLocation;
    private List<RoutingHandlerOptions> globalHandlers;
    private List<AuthHandlerOptions> securityHandlers;
    private List<RoutingOperationOptions> routingOperations;
    private DropRequestOptions dropRequestOptions;
    private HystrixMetricsOptions hystrixMetricsOptions;

    public KnotxServerOptions() {
        this.init();
    }

    public KnotxServerOptions(KnotxServerOptions other) {
        this.displayExceptionDetails = other.displayExceptionDetails;
        this.serverOptions = new HttpServerOptions(other.serverOptions);
        this.routingSpecificationLocation = other.routingSpecificationLocation;
        this.globalHandlers = new ArrayList<RoutingHandlerOptions>(other.globalHandlers);
        this.securityHandlers = new ArrayList<AuthHandlerOptions>(other.securityHandlers);
        this.routingOperations = new ArrayList<RoutingOperationOptions>(other.routingOperations);
        this.dropRequestOptions = other.dropRequestOptions;
        this.hystrixMetricsOptions = other.hystrixMetricsOptions;
    }

    public KnotxServerOptions(JsonObject json) {
        this.init();
        KnotxServerOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        this.serverOptions.setPort(Integer.getInteger("knotx.port", this.serverOptions.getPort()).intValue());
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        KnotxServerOptionsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.displayExceptionDetails = false;
        this.globalHandlers = new ArrayList<RoutingHandlerOptions>();
        this.securityHandlers = new ArrayList<AuthHandlerOptions>();
        this.serverOptions = new HttpServerOptions();
        this.dropRequestOptions = new DropRequestOptions();
        this.hystrixMetricsOptions = new HystrixMetricsOptions();
    }

    public boolean isDisplayExceptionDetails() {
        return this.displayExceptionDetails;
    }

    public KnotxServerOptions setDisplayExceptionDetails(boolean displayExceptionDetails) {
        this.displayExceptionDetails = displayExceptionDetails;
        return this;
    }

    public HttpServerOptions getServerOptions() {
        return this.serverOptions;
    }

    public KnotxServerOptions setServerOptions(HttpServerOptions serverOptions) {
        this.serverOptions = serverOptions;
        return this;
    }

    public String getRoutingSpecificationLocation() {
        return this.routingSpecificationLocation;
    }

    public KnotxServerOptions setRoutingSpecificationLocation(String routingSpecificationLocation) {
        this.routingSpecificationLocation = routingSpecificationLocation;
        return this;
    }

    public List<RoutingHandlerOptions> getGlobalHandlers() {
        return this.globalHandlers;
    }

    public KnotxServerOptions setGlobalHandlers(List<RoutingHandlerOptions> globalHandlers) {
        this.globalHandlers = globalHandlers;
        return this;
    }

    public List<AuthHandlerOptions> getSecurityHandlers() {
        return this.securityHandlers;
    }

    public KnotxServerOptions setSecurityHandlers(List<AuthHandlerOptions> securityHandlers) {
        this.securityHandlers = securityHandlers;
        return this;
    }

    public List<RoutingOperationOptions> getRoutingOperations() {
        return this.routingOperations;
    }

    public KnotxServerOptions setRoutingOperations(List<RoutingOperationOptions> routingOperations) {
        this.routingOperations = routingOperations;
        return this;
    }

    public DropRequestOptions getDropRequestOptions() {
        return this.dropRequestOptions;
    }

    public KnotxServerOptions setDropRequestOptions(DropRequestOptions dropRequestOptions) {
        this.dropRequestOptions = dropRequestOptions;
        return this;
    }

    public HystrixMetricsOptions getHystrixMetricsOptions() {
        return this.hystrixMetricsOptions;
    }

    public KnotxServerOptions setHystrixMetricsOptions(HystrixMetricsOptions hystrixMetricsOptions) {
        this.hystrixMetricsOptions = hystrixMetricsOptions;
        return this;
    }

    public String toString() {
        return "KnotxServerOptions{displayExceptionDetails=" + this.displayExceptionDetails + ", serverOptions=" + this.serverOptions + ", routingSpecificationLocation='" + this.routingSpecificationLocation + '\'' + ", globalHandlers=" + this.globalHandlers + ", securityHandlers=" + this.securityHandlers + ", routingOperations=" + this.routingOperations + ", dropRequestOptions=" + this.dropRequestOptions + ", hystrixMetricsOptions=" + this.hystrixMetricsOptions + '}';
    }
}

