/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.configuration;

import io.knotx.server.configuration.AuthHandlerOptions;
import io.knotx.server.configuration.DropRequestOptions;
import io.knotx.server.configuration.HystrixMetricsOptions;
import io.knotx.server.configuration.KnotxServerOptions;
import io.knotx.server.configuration.RoutingHandlerOptions;
import io.knotx.server.configuration.RoutingOperationOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Map;

class KnotxServerOptionsConverter {
    KnotxServerOptionsConverter() {
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, KnotxServerOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "displayExceptionDetails": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setDisplayExceptionDetails((Boolean)member.getValue());
                    break;
                }
                case "dropRequestOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setDropRequestOptions(new DropRequestOptions((JsonObject)member.getValue()));
                    break;
                }
                case "globalHandlers": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<RoutingHandlerOptions> list = new ArrayList<RoutingHandlerOptions>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new RoutingHandlerOptions((JsonObject)item));
                        }
                    });
                    obj.setGlobalHandlers(list);
                    break;
                }
                case "hystrixMetricsOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setHystrixMetricsOptions(new HystrixMetricsOptions((JsonObject)member.getValue()));
                    break;
                }
                case "routingOperations": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<RoutingHandlerOptions> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add((RoutingHandlerOptions)((Object)new RoutingOperationOptions((JsonObject)item)));
                        }
                    });
                    obj.setRoutingOperations(list);
                    break;
                }
                case "routingSpecificationLocation": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setRoutingSpecificationLocation((String)member.getValue());
                    break;
                }
                case "securityHandlers": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<RoutingHandlerOptions> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add((RoutingHandlerOptions)((Object)new AuthHandlerOptions((JsonObject)item)));
                        }
                    });
                    obj.setSecurityHandlers(list);
                    break;
                }
                case "serverOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setServerOptions(new HttpServerOptions((JsonObject)member.getValue()));
                }
            }
        }
    }

    static void toJson(KnotxServerOptions obj, JsonObject json) {
        KnotxServerOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(KnotxServerOptions obj, Map<String, Object> json) {
        JsonArray array;
        json.put("displayExceptionDetails", obj.isDisplayExceptionDetails());
        if (obj.getDropRequestOptions() != null) {
            json.put("dropRequestOptions", obj.getDropRequestOptions().toJson());
        }
        if (obj.getGlobalHandlers() != null) {
            array = new JsonArray();
            obj.getGlobalHandlers().forEach(item -> array.add(item.toJson()));
            json.put("globalHandlers", array);
        }
        if (obj.getHystrixMetricsOptions() != null) {
            json.put("hystrixMetricsOptions", obj.getHystrixMetricsOptions().toJson());
        }
        if (obj.getRoutingOperations() != null) {
            array = new JsonArray();
            obj.getRoutingOperations().forEach(item -> array.add(item.toJson()));
            json.put("routingOperations", array);
        }
        if (obj.getRoutingSpecificationLocation() != null) {
            json.put("routingSpecificationLocation", obj.getRoutingSpecificationLocation());
        }
        if (obj.getSecurityHandlers() != null) {
            array = new JsonArray();
            obj.getSecurityHandlers().forEach(item -> array.add(item.toJson()));
            json.put("securityHandlers", array);
        }
        if (obj.getServerOptions() != null) {
            json.put("serverOptions", obj.getServerOptions().toJson());
        }
    }
}

