/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.configuration;

import io.knotx.server.configuration.RoutingHandlerOptions;
import io.knotx.server.configuration.RoutingOperationOptionsConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@DataObject(generateConverter=true, publicConverter=false)
public class RoutingOperationOptions {
    private String operationId;
    private List<RoutingHandlerOptions> handlers;
    private List<RoutingHandlerOptions> failureHandlers;

    public RoutingOperationOptions(JsonObject json) {
        this.init();
        RoutingOperationOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        if (StringUtils.isBlank((CharSequence)this.operationId)) {
            throw new IllegalStateException("Operation ID in routing configuration can not be null [" + json + "]");
        }
    }

    public RoutingOperationOptions(RoutingOperationOptions other) {
        this.operationId = other.getOperationId();
        this.handlers = new ArrayList<RoutingHandlerOptions>(other.getHandlers());
        this.failureHandlers = new ArrayList<RoutingHandlerOptions>(other.getFailureHandlers());
    }

    private void init() {
        this.handlers = Collections.emptyList();
        this.failureHandlers = Collections.emptyList();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RoutingOperationOptionsConverter.toJson(this, json);
        return json;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public RoutingOperationOptions setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public List<RoutingHandlerOptions> getHandlers() {
        return this.handlers;
    }

    public RoutingOperationOptions setHandlers(List<RoutingHandlerOptions> handlers) {
        this.handlers = handlers;
        return this;
    }

    public List<RoutingHandlerOptions> getFailureHandlers() {
        return this.failureHandlers;
    }

    public RoutingOperationOptions setFailureHandlers(List<RoutingHandlerOptions> failureHandlers) {
        this.failureHandlers = failureHandlers;
        return this;
    }

    public String toString() {
        return "RoutingOperationOptions{operationId='" + this.operationId + '\'' + ", handlers=" + this.handlers + ", failureHandlers=" + this.failureHandlers + '}';
    }
}

