/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.handler.csrf;

import io.knotx.server.handler.csrf.CSRFOptionsConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;

@DataObject(generateConverter=true, publicConverter=false)
public class CSRFOptions {
    private static final long DEFAULT_TIMEOUT = 1800000L;
    private String cookieName;
    private String cookiePath;
    private String headerName;
    private String secret;
    private long timeout;

    public CSRFOptions() {
        this.init();
    }

    public CSRFOptions(CSRFOptions other) {
        this.cookieName = other.cookieName;
        this.cookiePath = other.cookiePath;
        this.headerName = other.headerName;
        this.secret = other.secret;
        this.timeout = other.timeout;
    }

    public CSRFOptions(JsonObject json) {
        this.init();
        CSRFOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        CSRFOptionsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.secret = RandomStringUtils.random((int)20);
        this.cookieName = "XSRF-TOKEN";
        this.cookiePath = "/";
        this.headerName = "X-XSRF-TOKEN";
        this.timeout = 1800000L;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public CSRFOptions setCookieName(String cookieName) {
        this.cookieName = cookieName;
        return this;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public CSRFOptions setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
        return this;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public CSRFOptions setHeaderName(String headerName) {
        this.headerName = headerName;
        return this;
    }

    public String getSecret() {
        return this.secret;
    }

    public CSRFOptions setSecret(String secret) {
        this.secret = secret;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public CSRFOptions setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }
}

