/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.handler.http.request.body;

import io.knotx.server.handler.http.request.body.BodyHandlerOptionsConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@DataObject(generateConverter=true, publicConverter=false)
public class BodyHandlerOptions {
    private static final String DEFAULT_UPLOAD_DIRECTORY = BodyHandlerOptions.getStringProperty("knotx.fileUploadDir", "file-uploads");
    private String fileUploadDirectory;
    private Long fileUploadLimit;

    public BodyHandlerOptions(JsonObject json) {
        this.init();
        if (json != null) {
            BodyHandlerOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        }
    }

    public void init() {
        this.fileUploadLimit = -1L;
        this.fileUploadDirectory = DEFAULT_UPLOAD_DIRECTORY;
    }

    public Long getFileUploadLimit() {
        return this.fileUploadLimit;
    }

    public BodyHandlerOptions setFileUploadLimit(Long fileUploadLimit) {
        this.fileUploadLimit = fileUploadLimit;
        return this;
    }

    public String getFileUploadDirectory() {
        return this.fileUploadDirectory;
    }

    public BodyHandlerOptions setFileUploadDirectory(String fileUploadDirectory) {
        this.fileUploadDirectory = fileUploadDirectory;
        return this;
    }

    private static String getStringProperty(String propertyName, String defaultVal) {
        String value = null;
        try {
            value = System.getProperty(propertyName);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return defaultVal;
    }
}

