/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.handler.http.response.header;

import io.knotx.server.api.handler.RoutingHandlerFactory;
import io.knotx.server.handler.http.response.header.CustomHttpHeaderOptions;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.web.RoutingContext;
import org.apache.commons.lang3.StringUtils;

public class CustomHeaderRoutingHandlerFactory
implements RoutingHandlerFactory {
    public String getName() {
        return "headerHandler";
    }

    public Handler<RoutingContext> create(Vertx vertx, JsonObject config) {
        return new CustomHeaderRoutingHandler(config);
    }

    static class CustomHeaderRoutingHandler
    implements Handler<RoutingContext> {
        private CustomHttpHeaderOptions customHeader;

        CustomHeaderRoutingHandler(JsonObject configuration) {
            this.customHeader = new CustomHttpHeaderOptions(configuration);
        }

        public void handle(RoutingContext context) {
            if (this.customHeader != null && StringUtils.isNotBlank((CharSequence)this.customHeader.getName())) {
                context.response().headers().add(this.customHeader.getName(), this.customHeader.getValue());
            }
            context.next();
        }
    }
}

