/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.handler.http.response.writer;

import io.knotx.server.api.context.RequestContext;
import io.knotx.server.handler.http.response.writer.ServerResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.core.http.HttpServerResponse;
import io.vertx.reactivex.ext.web.RoutingContext;
import java.util.Set;

class ResponseWriterHandler
implements Handler<RoutingContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseWriterHandler.class);
    private final Set<String> allowedResponseHeaders;

    ResponseWriterHandler(Set<String> allowedResponseHeaders) {
        this.allowedResponseHeaders = allowedResponseHeaders;
    }

    public void handle(RoutingContext context) {
        RequestContext requestContext = (RequestContext)context.get("requestContext");
        this.traceRequest(requestContext);
        try {
            ServerResponse serverResponse = new ServerResponse(requestContext);
            serverResponse.end(context.response(), this.allowedResponseHeaders);
        }
        catch (Exception e) {
            this.handleFatal(context, e);
        }
    }

    private void traceRequest(RequestContext requestContext) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"Request history: {}", new Object[]{requestContext.toJson().encodePrettily()});
        }
    }

    private void handleFatal(RoutingContext context, Exception e) {
        LOGGER.error((Object)"Fatal error", (Throwable)e);
        HttpServerResponse httpResponse = context.response();
        httpResponse.setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        httpResponse.end();
    }
}

