/*
 * Decompiled with CFR 0.152.
 */
package io.knotx.server.handler.http.response.writer;

import io.knotx.server.api.context.ClientResponse;
import io.knotx.server.api.context.RequestContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.http.HttpServerResponse;
import java.util.Optional;
import java.util.Set;

class ServerResponse {
    private ClientResponse clientResponse;
    private boolean ok;

    ServerResponse(RequestContext requestContext) {
        this.clientResponse = requestContext.getClientResponse();
        this.ok = ServerResponse.isOk(requestContext);
    }

    void end(HttpServerResponse httpResponse, Set<String> allowedResponseHeaders) {
        httpResponse.setStatusCode(this.getStatusCode());
        if (this.ok) {
            httpResponse.headers().addAll(this.getHeaders(allowedResponseHeaders));
            this.clearContentLengthHeader(httpResponse);
            if (this.getBody().isPresent()) {
                httpResponse.end(this.getBody().get());
            } else {
                httpResponse.end();
            }
        } else {
            httpResponse.end();
        }
    }

    private void clearContentLengthHeader(HttpServerResponse httpResponse) {
        httpResponse.headers().remove(HttpHeaders.CONTENT_LENGTH.toString());
    }

    private int getStatusCode() {
        HttpStatusClass httpStatusClass = HttpStatusClass.valueOf((int)this.clientResponse.getStatusCode());
        int statusCode = httpStatusClass != HttpStatusClass.UNKNOWN ? this.clientResponse.getStatusCode() : HttpResponseStatus.INTERNAL_SERVER_ERROR.code();
        return statusCode;
    }

    private MultiMap getHeaders(Set<String> allowedResponseHeaders) {
        MultiMap headers = MultiMap.caseInsensitiveMultiMap();
        if (this.clientResponse.getHeaders() != null) {
            this.clientResponse.getHeaders().names().stream().filter(header -> this.headerFilter(allowedResponseHeaders, (String)header)).forEach(name -> this.clientResponse.getHeaders().getAll(name).forEach(value -> headers.add(name, value)));
        }
        return headers;
    }

    private Optional<io.vertx.reactivex.core.buffer.Buffer> getBody() {
        Buffer crBody = this.clientResponse.getBody();
        io.vertx.reactivex.core.buffer.Buffer result = null;
        if (crBody != null) {
            result = io.vertx.reactivex.core.buffer.Buffer.newInstance((Buffer)crBody);
        }
        return Optional.ofNullable(result);
    }

    private static boolean isOk(RequestContext requestContext) {
        return !requestContext.getStatus().isFailed();
    }

    private Boolean headerFilter(Set<String> allowedResponseHeaders, String name) {
        return allowedResponseHeaders.contains(name.toLowerCase());
    }
}

