/*
 * Decompiled with CFR 0.152.
 */
package f2.spring;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import f2.dsl.cqrs.error.F2Error;
import f2.dsl.cqrs.error.F2ErrorDTO;
import f2.dsl.cqrs.exception.F2Exception;
import f2.spring.KSerializationMapper;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.MissingFieldException;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JvmStreamsKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.core.ResolvableType;
import org.springframework.util.ConcurrentReferenceHashMap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010J#\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\fH\u0016J\n\u0010\u001c\u001a\u00020\u001d*\u00020\u001eR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lf2/spring/KSerializationMapper;", "Lorg/springframework/cloud/function/json/JsonMapper;", "mapper", "Lkotlinx/serialization/json/Json;", "(Lkotlinx/serialization/json/Json;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "serializerCache", "", "Ljava/lang/reflect/Type;", "Lkotlinx/serialization/KSerializer;", "", "configureObjectMapper", "", "configurer", "Ljava/util/function/Consumer;", "doFromJson", "T", "json", "type", "(Ljava/lang/Object;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "serializer", "toJson", "", "value", "toString", "", "toInputStream", "Ljava/io/InputStream;", "Ljava/io/Reader;", "Companion", "f2-spring-boot-starter-function"})
@SourceDebugExtension(value={"SMAP\nKSerializationMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KSerializationMapper.kt\nf2/spring/KSerializationMapper\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n113#2:138\n372#3,7:139\n1#4:146\n*S KotlinDebug\n*F\n+ 1 KSerializationMapper.kt\nf2/spring/KSerializationMapper\n*L\n104#1:138\n112#1:139,7\n*E\n"})
public final class KSerializationMapper
extends JsonMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Json mapper;
    private final Logger logger;
    @NotNull
    private final Map<Type, KSerializer<Object>> serializerCache;
    @NotNull
    private static final Json defaultJson = JsonKt.Json$default(null, (Function1)Companion.defaultJson.1.INSTANCE, (int)1, null);

    public KSerializationMapper(@NotNull Json mapper) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.mapper = mapper;
        this.logger = LoggerFactory.getLogger(KSerializationMapper.class);
        this.serializerCache = (Map)new ConcurrentReferenceHashMap();
    }

    public final void configureObjectMapper(@NotNull Consumer<Json> configurer) {
        Intrinsics.checkNotNullParameter(configurer, (String)"configurer");
        configurer.accept(this.mapper);
    }

    protected <T> T doFromJson(@NotNull Object json, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        try {
            Object object;
            KSerializer<Object> kSerializer = this.serializer(type);
            Intrinsics.checkNotNull(kSerializer);
            KSerializer<Object> serializerType = kSerializer;
            if (json instanceof String) {
                object = this.mapper.decodeFromString((DeserializationStrategy)serializerType, (String)json);
            } else if (json instanceof byte[]) {
                object = this.mapper.decodeFromString((DeserializationStrategy)serializerType, new String((byte[])json, Charsets.UTF_8));
            } else if (json instanceof Reader) {
                object = JvmStreamsKt.decodeFromStream((Json)this.mapper, (DeserializationStrategy)((DeserializationStrategy)serializerType), (InputStream)this.toInputStream((Reader)json));
            } else if (json instanceof JsonElement) {
                object = this.mapper.decodeFromJsonElement((DeserializationStrategy)serializerType, (JsonElement)json);
            } else {
                throw new IllegalStateException(("Failed to convert. Unknown type " + Reflection.getOrCreateKotlinClass(json.getClass()).getQualifiedName()).toString());
            }
            return (T)object;
        }
        catch (MissingFieldException e) {
            String string = UUID.randomUUID().toString();
            String string2 = String.valueOf(System.currentTimeMillis());
            String string3 = "Missing parameter `" + CollectionsKt.joinToString$default((Iterable)e.getMissingFields(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "`";
            throw new F2Exception((F2ErrorDTO)new F2Error(string3, string, string2, 400, null, 16, null), (Throwable)e);
        }
        catch (SerializationException e) {
            String string = UUID.randomUUID().toString();
            String string4 = String.valueOf(System.currentTimeMillis());
            String string5 = e.getMessage();
            Intrinsics.checkNotNull((Object)string5);
            String string6 = string5;
            throw new F2Exception((F2ErrorDTO)new F2Error(string6, string, string4, 400, null, 16, null), (Throwable)e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert. Possible bug as the conversion probably shouldn't have been attempted here", e);
        }
    }

    @NotNull
    public byte[] toJson(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ResolvableType resolvableType = ResolvableType.forClass(value.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)resolvableType, (String)"forClass(...)");
        ResolvableType type = resolvableType;
        Type type2 = type.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
        KSerializer<Object> kSerializer = this.serializer(type2);
        Intrinsics.checkNotNull(kSerializer);
        KSerializer<Object> ser = kSerializer;
        byte[] jsonBytes = super.toJson(value);
        if (jsonBytes == null) {
            try {
                object = this.mapper.encodeToString((SerializationStrategy)ser, value);
                byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                jsonBytes = byArray;
            }
            catch (Exception e) {
                this.logger.debug("Ignored Error while serializing " + value, (Throwable)e);
                try {
                    jsonBytes = new ObjectMapper().writeValueAsBytes(value);
                }
                catch (Exception e2) {
                    this.logger.debug("Ignored Error while serializing " + value, (Throwable)e2);
                }
            }
        }
        object = jsonBytes;
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    @NotNull
    public String toString(@NotNull Object value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            StringFormat $this$encodeToString$iv = (StringFormat)this.mapper;
            boolean $i$f$encodeToString = false;
            SerializersModule serializersModule = $this$encodeToString$iv.getSerializersModule();
            KType kType = Reflection.typeOf(Object.class);
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            string = $this$encodeToString$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), value);
        }
        catch (JsonProcessingException e) {
            this.logger.debug("Ignored Error while serializing " + value, (Throwable)e);
            return "Cannot convert to JSON";
        }
        return string;
    }

    private final KSerializer<Object> serializer(Type type) {
        KSerializer kSerializer;
        Map<Type, KSerializer<Object>> $this$getOrPut$iv = this.serializerCache;
        boolean $i$f$getOrPut = false;
        KSerializer value$iv = $this$getOrPut$iv.get(type);
        if (value$iv == null) {
            KSerializer kSerializer2;
            boolean bl = false;
            try {
                kSerializer2 = SerializersKt.serializer((Type)type);
            }
            catch (Exception e) {
                this.logger.debug("Ignored Error while serializing " + type, (Throwable)e);
                KSerializer kSerializer3 = JsonElement.Companion.serializer();
                Intrinsics.checkNotNull((Object)kSerializer3, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any>");
                kSerializer2 = kSerializer3;
            }
            KSerializer answer$iv = kSerializer2;
            $this$getOrPut$iv.put(type, (KSerializer<Object>)answer$iv);
            kSerializer = answer$iv;
        } else {
            kSerializer = value$iv;
        }
        return kSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final InputStream toInputStream(@NotNull Reader $this$toInputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        Intrinsics.checkNotNullParameter((Object)$this$toInputStream, (String)"<this>");
        Closeable closeable = $this$toInputStream;
        Throwable throwable = null;
        try {
            Reader initialReader = (Reader)closeable;
            boolean bl = false;
            char[] charBuffer = new char[8192];
            StringBuilder builder = new StringBuilder();
            int numCharsRead = 0;
            while (true) {
                int n;
                int it = n = initialReader.read(charBuffer, 0, charBuffer.length);
                boolean bl2 = false;
                numCharsRead = it;
                if (n == -1) break;
                builder.append(charBuffer, 0, numCharsRead);
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byteArrayInputStream;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lf2/spring/KSerializationMapper$Companion;", "", "()V", "defaultJson", "Lkotlinx/serialization/json/Json;", "getDefaultJson", "()Lkotlinx/serialization/json/Json;", "f2-spring-boot-starter-function"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Json getDefaultJson() {
            return defaultJson;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

