/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.config.CoroutinesUtils;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;

@Configuration
@ConditionalOnClass(name={"kotlin.jvm.functions.Function0"})
public class KotlinLambdaToFunctionAutoConfiguration {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.http.converter.json.Jackson2ObjectMapperBuilder", "com.fasterxml.jackson.module.kotlin.KotlinModule"})
    Jackson2ObjectMapperBuilderCustomizer customizer() {
        return new Jackson2ObjectMapperBuilderCustomizer(){

            public void customize(Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder) {
                jacksonObjectMapperBuilder.modulesToInstall(new Class[]{KotlinModule.class});
            }
        };
    }

    public static final class KotlinFunctionWrapper
    implements Function<Object, Object>,
    Supplier<Object>,
    Consumer<Object>,
    Function0<Object>,
    Function1<Object, Object>,
    Function2<Object, Object, Object>,
    Function3<Object, Object, Object, Object>,
    Function4<Object, Object, Object, Object, Object> {
        private final Object kotlinLambdaTarget;
        private String name;
        private ConfigurableListableBeanFactory beanFactory;

        public KotlinFunctionWrapper(Object kotlinLambdaTarget) {
            this.kotlinLambdaTarget = kotlinLambdaTarget;
        }

        @Override
        public Object apply(Object input) {
            if (ObjectUtils.isEmpty((Object)input)) {
                return this.invoke();
            }
            return this.invoke(input);
        }

        public Object invoke(Object arg0, Object arg1, Object arg2, Object arg3) {
            return ((Function4)this.kotlinLambdaTarget).invoke(arg0, arg1, arg2, arg3);
        }

        public Object invoke(Object arg0, Object arg1, Object arg2) {
            return ((Function3)this.kotlinLambdaTarget).invoke(arg0, arg1, arg2);
        }

        public Object invoke(Object arg0, Object arg1) {
            return ((Function2)this.kotlinLambdaTarget).invoke(arg0, arg1);
        }

        public Object invoke(Object arg0) {
            if (CoroutinesUtils.isValidSuspendingFunction((Object)this.kotlinLambdaTarget, (Object)arg0)) {
                return CoroutinesUtils.invokeSuspendingFunction((Object)this.kotlinLambdaTarget, (Object)arg0);
            }
            if (this.kotlinLambdaTarget instanceof Function1) {
                return ((Function1)this.kotlinLambdaTarget).invoke(arg0);
            }
            if (this.kotlinLambdaTarget instanceof Function) {
                return ((Function)this.kotlinLambdaTarget).apply(arg0);
            }
            ((Consumer)this.kotlinLambdaTarget).accept(arg0);
            return null;
        }

        public Object invoke() {
            if (CoroutinesUtils.isValidSuspendingSupplier((Object)this.kotlinLambdaTarget)) {
                return CoroutinesUtils.invokeSuspendingSupplier((Object)this.kotlinLambdaTarget);
            }
            if (this.kotlinLambdaTarget instanceof Function0) {
                return ((Function0)this.kotlinLambdaTarget).invoke();
            }
            return ((Supplier)this.kotlinLambdaTarget).get();
        }

        @Override
        public void accept(Object input) {
            if (CoroutinesUtils.isValidSuspendingFunction((Object)this.kotlinLambdaTarget, (Object)input)) {
                CoroutinesUtils.invokeSuspendingConsumer((Object)this.kotlinLambdaTarget, (Object)input);
                return;
            }
            this.apply(input);
        }

        @Override
        public Object get() {
            return this.apply((Object)null);
        }

        public FunctionRegistration getFunctionRegistration() {
            String name = this.name.endsWith(FunctionRegistration.REGISTRATION_NAME_SUFFIX) ? this.name.replace(FunctionRegistration.REGISTRATION_NAME_SUFFIX, "") : this.name;
            Type functionType = FunctionContextUtils.findType((String)name, (ConfigurableListableBeanFactory)this.beanFactory);
            FunctionRegistration registration = new FunctionRegistration((Object)this, new String[]{name});
            Type[] types = ((ParameterizedType)functionType).getActualTypeArguments();
            if (this.isValidKotlinSupplier(functionType)) {
                functionType = ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)types[0])}).getType();
            } else if (this.isValidKotlinConsumer(functionType, types)) {
                functionType = ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)types[0])}).getType();
            } else if (this.isValidKotlinFunction(functionType, types)) {
                functionType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)types[0]), ResolvableType.forType((Type)types[1])}).getType();
            } else if (this.isValidKotlinSuspendSupplier(functionType, types)) {
                Type continuationReturnType = CoroutinesUtils.getSuspendingFunctionReturnType((Type)types[0]);
                functionType = ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)continuationReturnType)})}).getType();
            } else if (this.isValidKotlinSuspendFunction(functionType, types)) {
                Type continuationArgType = CoroutinesUtils.getSuspendingFunctionArgType((Type)types[0]);
                Type continuationReturnType = CoroutinesUtils.getSuspendingFunctionReturnType((Type)types[1]);
                functionType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)continuationArgType)}), ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)continuationReturnType)})}).getType();
            } else if (this.isValidKotlinSuspendConsumer(functionType, types)) {
                Type continuationArgType = CoroutinesUtils.getSuspendingFunctionArgType((Type)types[0]);
                functionType = ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)continuationArgType)})}).getType();
            } else if (!(FunctionTypeUtils.isFunction((Type)functionType) || FunctionTypeUtils.isConsumer((Type)functionType) || FunctionTypeUtils.isSupplier((Type)functionType))) {
                throw new UnsupportedOperationException("Multi argument Kotlin functions are not currently supported");
            }
            registration = registration.type(functionType);
            return registration;
        }

        private boolean isValidKotlinSupplier(Type functionType) {
            return this.isTypeRepresentedByClass(functionType, Function0.class);
        }

        private boolean isValidKotlinConsumer(Type functionType, Type[] type) {
            return this.isTypeRepresentedByClass(functionType, Function1.class) && type.length == 2 && !CoroutinesUtils.isContinuationType((Type)type[0]) && this.isTypeRepresentedByClass(type[1], Unit.class);
        }

        private boolean isValidKotlinFunction(Type functionType, Type[] type) {
            return this.isTypeRepresentedByClass(functionType, Function1.class) && type.length == 2 && !CoroutinesUtils.isContinuationType((Type)type[0]) && !this.isTypeRepresentedByClass(type[1], Unit.class);
        }

        private boolean isValidKotlinSuspendSupplier(Type functionType, Type[] type) {
            return this.isTypeRepresentedByClass(functionType, Function1.class) && (type.length == 1 || type.length == 2 && CoroutinesUtils.isContinuationFlowType((Type)type[0]));
        }

        private boolean isValidKotlinSuspendConsumer(Type functionType, Type[] type) {
            return this.isTypeRepresentedByClass(functionType, Function2.class) && (type.length == 1 || type.length == 3 && CoroutinesUtils.isContinuationUnitType((Type)type[1]) && CoroutinesUtils.isFlowType((Type)type[0]));
        }

        private boolean isValidKotlinSuspendFunction(Type functionType, Type[] type) {
            return this.isTypeRepresentedByClass(functionType, Function2.class) && (type.length == 3 && CoroutinesUtils.isContinuationFlowType((Type)type[1]) || type.length == 2);
        }

        private boolean isTypeRepresentedByClass(Type type, Class<?> clazz) {
            return this.concatWithSuperTypes(type).stream().map(Type::getTypeName).map(s -> s.contains(clazz.getName())).reduce((a, b) -> a != false || b != false).orElse(false);
        }

        private List<Type> concatWithSuperTypes(Type type) {
            ArrayList<Type> all = new ArrayList<Type>();
            all.add(type);
            if (type instanceof ParameterizedType) {
                Class<?>[] interfaces = ((Class)((ParameterizedType)type).getRawType()).getInterfaces();
                all.addAll(List.of(interfaces));
            }
            return all;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }
    }
}

