/*
 * Decompiled with CFR 0.152.
 */
package io.konig.maven.project.generator;

import io.konig.maven.DataServicesConfig;
import io.konig.maven.Exclude;
import io.konig.maven.GoogleCloudPlatformConfig;
import io.konig.maven.JavaCodeGeneratorConfig;
import io.konig.maven.ModelValidationConfig;
import io.konig.maven.WorkbookProcessorConfig;
import io.konig.maven.project.generator.XmlSerializer;
import io.konig.validation.CaseStyle;
import io.konig.validation.CaseStyleConventions;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.InputLocation;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class XmlSerializerTest {
    @Test
    public void testModelValidationConfig() {
        ModelValidationConfig model = new ModelValidationConfig();
        CaseStyleConventions namingConventions = new CaseStyleConventions();
        model.setTextReportFile(new File("target/generated/rdf/validation.txt"));
        namingConventions.setClasses(CaseStyle.PascalCase);
        model.setNamingConventions(namingConventions);
        StringWriter out = new StringWriter();
        XmlSerializer xml = new XmlSerializer((Writer)out);
        xml.write((Object)model, "modelValidation");
        xml.flush();
        String actual = out.toString();
        Assert.assertTrue((boolean)actual.contains("<textReportFile>target/generated/rdf/validation.txt</textReportFile>"));
        Assert.assertTrue((boolean)actual.contains("<classes>PascalCase</classes>"));
    }

    @Ignore
    public void testDistributionManagement() {
        DistributionManagement pojo = new DistributionManagement();
        DeploymentRepository repository = new DeploymentRepository();
        repository.setId("pearson-releases");
        repository.setUniqueVersion(true);
        repository.setName("Pearson EDW Releases");
        repository.setUrl("https://devops-tools.pearson.com/nexus-master/content/repositories/releases/edw/");
        pojo.setRepository(repository);
        pojo.setLocation((Object)"foo", new InputLocation(1, 1));
        StringWriter out = new StringWriter();
        XmlSerializer xml = new XmlSerializer((Writer)out);
        xml.write((Object)pojo, "distributionManagement");
        xml.flush();
        String actual = out.toString();
        Assert.assertTrue((boolean)actual.contains("pearson-releases"));
    }

    @Ignore
    public void testJava() {
        JavaCodeGeneratorConfig java = new JavaCodeGeneratorConfig();
        ArrayList<Exclude> filter = new ArrayList<Exclude>();
        java.setFilter(filter);
        Exclude exclude = new Exclude();
        filter.add(exclude);
        HashSet<String> namespaces = new HashSet<String>();
        exclude.setNamespaces(namespaces);
        namespaces.add("http://schema.org/");
        StringWriter buffer = new StringWriter();
        buffer.write("\n");
        XmlSerializer serializer = new XmlSerializer((Writer)buffer);
        serializer.setIndent(1);
        serializer.indent();
        serializer.write((Object)java, "java");
        serializer.flush();
        String expected = "\n   <java>\n      <generateCanonicalJsonReaders>false</generateCanonicalJsonReaders>\n      <filter>\n         <exclude>\n            <namespaces>\n               <param>http://schema.org/</param>\n            </namespaces>\n         </exclude>\n      </filter>\n   </java>\n";
        String actual = buffer.toString().replace("\r", "");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Ignore
    public void testWorkbook() {
        WorkbookProcessorConfig workbook = new WorkbookProcessorConfig();
        workbook.setWorkbookFile(new File("foo/bar.xlsx"));
        StringWriter buffer = new StringWriter();
        buffer.write("\n");
        XmlSerializer serializer = new XmlSerializer((Writer)buffer);
        serializer.setIndent(1);
        serializer.indent();
        serializer.write((Object)workbook, "googleCloudPlatform");
        serializer.flush();
        String expected = "\n   <googleCloudPlatform>\n      <workbookFile>foo/bar.xlsx</workbookFile>\n      <inferRdfPropertyDefinitions>true</inferRdfPropertyDefinitions>\n      <failOnWarnings>false</failOnWarnings>\n      <failOnErrors>true</failOnErrors>\n   </googleCloudPlatform>\n";
        String actual = buffer.toString().replace("\r", "");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Ignore
    public void testGoogleCloudPlatform() {
        DataServicesConfig dataServices = new DataServicesConfig();
        dataServices.setBasedir(new File("base/foo"));
        dataServices.setInfoFile(new File("config/info.yaml"));
        GoogleCloudPlatformConfig config = new GoogleCloudPlatformConfig();
        config.setBigQueryDatasetId("datasetId");
        config.setCredentials(new File("auth/credentials.json"));
        config.setDataServices(dataServices);
        StringWriter buffer = new StringWriter();
        buffer.write("\n");
        XmlSerializer serializer = new XmlSerializer((Writer)buffer);
        serializer.setIndent(1);
        serializer.indent();
        serializer.write((Object)config, "googleCloudPlatform");
        serializer.flush();
        String expected = "\n   <googleCloudPlatform>\n      <bigQueryDatasetId>datasetId</bigQueryDatasetId>\n      <credentials>auth/credentials.json</credentials>\n      <dataServices>\n         <basedir>base/foo</basedir>\n         <infoFile>config/info.yaml</infoFile>\n      </dataServices>\n      <enableBigQueryTransform>true</enableBigQueryTransform>\n      <enableMySqlTransform>true</enableMySqlTransform>\n      <omitTypeFromEnumTables>false</omitTypeFromEnumTables>\n   </googleCloudPlatform>\n";
        String actual = buffer.toString().replace("\r", "");
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

