/*
 * Decompiled with CFR 0.152.
 */
package io.konig.openapi.generator;

import io.konig.jsonschema.generator.JsonSchemaGenerator;
import io.konig.jsonschema.generator.JsonSchemaGeneratorException;
import io.konig.jsonschema.generator.JsonSchemaNamer;
import io.konig.jsonschema.model.JsonSchema;
import io.konig.openapi.generator.Entity;
import io.konig.openapi.generator.MediaType;
import io.konig.openapi.generator.OpenApiGenerateRequest;
import io.konig.openapi.generator.OpenApiGeneratorException;
import io.konig.openapi.model.Components;
import io.konig.openapi.model.OpenAPI;
import io.konig.openapi.model.SchemaMap;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeFilter;
import io.konig.shacl.ShapeManager;
import io.konig.yaml.AnchorFeature;
import io.konig.yaml.Yaml;
import io.konig.yaml.YamlWriterConfig;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.openrdf.model.URI;

public class OpenApiGenerator {
    private static final String OPENAPI_VERSION = "3.0.0";
    private static final String VELOCITY_TEMPLATE = "openapi-generator/openapi.yaml";
    private static final String ENTITY_LIST = "entityList";
    private JsonSchemaGenerator jsonSchemaGenerator;
    private JsonSchemaNamer jsonSchemaNamer;
    private ShapeFilter shapeFilter;
    private File velocityLog;

    public OpenApiGenerator(JsonSchemaNamer jsonSchemaNamer, JsonSchemaGenerator jsonSchemaGenerator, ShapeFilter shapeFilter) {
        this.jsonSchemaNamer = jsonSchemaNamer;
        this.jsonSchemaGenerator = jsonSchemaGenerator;
        this.shapeFilter = shapeFilter;
    }

    public File getVelocityLog() {
        return this.velocityLog;
    }

    public void setVelocityLog(File velocityLog) {
        this.velocityLog = velocityLog;
    }

    public void generate(OpenApiGenerateRequest request) throws OpenApiGeneratorException {
        try {
            Worker worker = new Worker();
            worker.generate(request);
        }
        catch (JsonSchemaGeneratorException | IOException e) {
            throw new OpenApiGeneratorException(e);
        }
    }

    private class Worker {
        private ShapeManager shapeManager;
        private Map<URI, Entity> entityMap = new HashMap<URI, Entity>();
        private VelocityEngine engine;
        private VelocityContext context;
        private OpenApiGenerateRequest request;
        private List<Shape> shapeList = new ArrayList<Shape>();
        private PrintWriter out;

        private Worker() {
        }

        private void generate(OpenApiGenerateRequest request) throws OpenApiGeneratorException, IOException, JsonSchemaGeneratorException {
            this.request = request;
            this.shapeManager = request.getShapeManager();
            this.createPrintWriter();
            this.createVelocityEngine();
            this.createContext();
            this.printOpenapiProperty();
            this.printInfo();
            this.merge();
            this.printComponents();
            this.out.flush();
        }

        private void printInfo() throws OpenApiGeneratorException, IOException {
            if (this.request.getOpenApiInfo() == null) {
                throw new OpenApiGeneratorException("OpenApiGenerateRequest.openApiInfo must be defined");
            }
            IOUtils.copy((Reader)this.request.getOpenApiInfo(), (Writer)this.out);
            this.out.println();
        }

        private void printOpenapiProperty() {
            this.out.print("openapi: ");
            this.out.println(OpenApiGenerator.OPENAPI_VERSION);
        }

        private void printComponents() throws JsonSchemaGeneratorException {
            OpenAPI api = new OpenAPI();
            Components components = new Components();
            api.setComponents(components);
            this.addSchemas(components);
            YamlWriterConfig config = new YamlWriterConfig().setAnchorFeature(AnchorFeature.NONE).setIncludeClassTag(false);
            Yaml.write((Writer)this.out, (YamlWriterConfig)config, (Object)api);
        }

        private void addSchemas(Components components) throws JsonSchemaGeneratorException {
            components.setSchemas(new SchemaMap());
            for (Shape shape : this.shapeList) {
                JsonSchema schema = OpenApiGenerator.this.jsonSchemaGenerator.asJsonSchema(shape);
                String name = OpenApiGenerator.this.jsonSchemaNamer.schemaId(shape);
                components.getSchemas().put((Object)name, (Object)schema);
            }
        }

        private void createPrintWriter() {
            this.out = this.request.getWriter() instanceof PrintWriter ? (PrintWriter)this.request.getWriter() : new PrintWriter(this.request.getWriter());
        }

        private void merge() throws IOException {
            Template template = this.engine.getTemplate(OpenApiGenerator.VELOCITY_TEMPLATE);
            template.merge((Context)this.context, (Writer)this.out);
        }

        private void createContext() throws OpenApiGeneratorException {
            this.context = new VelocityContext();
            this.buildEntityMap();
            ArrayList<Entity> entityList = new ArrayList<Entity>(this.entityMap.values());
            if (entityList.isEmpty()) {
                throw new OpenApiGeneratorException("Entity list is empty");
            }
            Collections.sort(entityList);
            this.context.put(OpenApiGenerator.ENTITY_LIST, entityList);
        }

        private void createVelocityEngine() {
            Properties properties = new Properties();
            properties.put("resource.loader", "class");
            properties.put("class.resource.loader.class", ClasspathResourceLoader.class.getName());
            if (OpenApiGenerator.this.velocityLog != null) {
                properties.put("runtime.log", OpenApiGenerator.this.velocityLog.getAbsolutePath());
            }
            this.engine = new VelocityEngine(properties);
        }

        private void buildEntityMap() {
            for (Shape shape : this.shapeManager.listShapes()) {
                URI targetClass;
                if (!OpenApiGenerator.this.shapeFilter.accept(shape) || !((targetClass = shape.getTargetClass()) instanceof URI)) continue;
                String refValue = OpenApiGenerator.this.jsonSchemaNamer.schemaId(shape);
                Entity entity = this.produceEntity(targetClass);
                entity.addShape(shape);
                entity.addMediaType(new MediaType(shape.getMediaTypeBaseName() + "+json", refValue));
                this.shapeList.add(shape);
            }
        }

        private Entity produceEntity(URI targetClass) {
            Entity e = this.entityMap.get(targetClass);
            if (e == null) {
                e = new Entity(targetClass);
                this.entityMap.put(targetClass, e);
            }
            return e;
        }
    }
}

