/*
 * Decompiled with CFR 0.152.
 */
package io.konig.openapi.generator;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.Vertex;
import io.konig.core.vocab.Konig;
import io.konig.shacl.NodeKind;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeFilter;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDFS;

public class RootClassShapeFilter
implements ShapeFilter {
    private Graph graph;

    public RootClassShapeFilter(Graph graph) {
        this.graph = graph;
    }

    public boolean accept(Shape shape) {
        boolean ok = false;
        if (shape.getNodeKind() == NodeKind.IRI && shape.getMediaTypeBaseName() != null && shape.hasDataSourceType(Konig.GoogleBigQueryTable)) {
            Set set;
            ok = true;
            URI targetClass = shape.getTargetClass();
            Vertex v = this.graph.getVertex((Resource)targetClass);
            if (v != null && !(set = v.outProperty(RDFS.SUBCLASSOF)).isEmpty()) {
                for (Edge e : set) {
                    Value superClass = e.getObject();
                    if (superClass.equals(OWL.THING)) continue;
                    ok = false;
                    break;
                }
            }
        }
        return ok;
    }
}

