package io.kotest.core.factory

import io.kotest.core.SourceRef
import io.kotest.core.Tag
import io.kotest.core.extensions.Extension
import io.kotest.core.listeners.TestListener
import io.kotest.core.spec.Spec
import io.kotest.core.test.*

/**
 * A [TestFactory] is a generator of tests along with optional configuration and
 * callbacks related to those tests. A test factory can be added to a [Spec] and the
 * tests generated by the factory will be included in that spec.
 */
data class TestFactory(
   val factoryId: TestFactoryId,
   val tests: List<DynamicTest>,
   val tags: Set<Tag>,
   val assertionMode: AssertionMode?,
   val listeners: List<TestListener>,
   val extensions: List<Extension>,
   val factories: List<TestFactory>
)

/**
 * A [DynamicTest] is an intermediate test state held by a factory. Once the factory is added to a
 * [Spec] and the spec is created, the factories dynamic tests will be added to the spec
 * as fully fledged [TestCase]s.
 */
data class DynamicTest(
   val name: TestName,
   val test: suspend TestContext.() -> Unit,
   val config: TestCaseConfig,
   val type: TestType,
   val source: SourceRef
)
