/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.matchers.bigdecimal;

import io.kotlintest.DslKt;
import io.kotlintest.Matcher;
import io.kotlintest.MatcherResult;
import io.kotlintest.matchers.ComparableMatchersKt;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\t\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u001a\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\b\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u001b\u0010\t\u001a\u00020\u0006*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\n\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u000b\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\n\u0010\f\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0006*\u00020\u0002\u001a\u0015\u0010\u000f\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010\u0012\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010\u0014\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0015\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u001b\u0010\u0016\u001a\u00020\u0006*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u0017\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0018\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0019\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0011H\u0086\u0004\u00a8\u0006\u001a"}, d2={"beInClosedRange", "Lio/kotlintest/Matcher;", "Ljava/math/BigDecimal;", "range", "Lkotlin/ranges/ClosedRange;", "shouldBeGreaterThan", "", "other", "shouldBeGreaterThanOrEquals", "shouldBeInRange", "shouldBeLessThan", "shouldBeLessThanOrEquals", "shouldBeNegative", "shouldBePositive", "shouldBeZero", "shouldHavePrecision", "precision", "", "shouldHaveScale", "scale", "shouldNotBeGreaterThan", "shouldNotBeGreaterThanOrEquals", "shouldNotBeInRange", "shouldNotBeLessThan", "shouldNotBeLessThanOrEquals", "shouldNotHaveScale", "kotlintest-assertions"})
public final class MatchersKt {
    public static final void shouldBeZero(@NotNull BigDecimal $this$shouldBeZero) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeZero, (String)"$this$shouldBeZero");
        DslKt.shouldBe($this$shouldBeZero, BigDecimal.ZERO);
    }

    public static final void shouldBePositive(@NotNull BigDecimal $this$shouldBePositive) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBePositive, (String)"$this$shouldBePositive");
        DslKt.shouldBe($this$shouldBePositive, ComparableMatchersKt.gte((Comparable)BigDecimal.ZERO));
    }

    public static final void shouldBeNegative(@NotNull BigDecimal $this$shouldBeNegative) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeNegative, (String)"$this$shouldBeNegative");
        DslKt.shouldBe($this$shouldBeNegative, ComparableMatchersKt.lt((Comparable)BigDecimal.ZERO));
    }

    public static final void shouldHavePrecision(@NotNull BigDecimal $this$shouldHavePrecision, int precision) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldHavePrecision, (String)"$this$shouldHavePrecision");
        DslKt.shouldBe($this$shouldHavePrecision.precision(), precision);
    }

    public static final void shouldHaveScale(@NotNull BigDecimal $this$shouldHaveScale, int scale) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldHaveScale, (String)"$this$shouldHaveScale");
        DslKt.shouldBe($this$shouldHaveScale.scale(), scale);
    }

    public static final void shouldNotHaveScale(@NotNull BigDecimal $this$shouldNotHaveScale, int scale) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotHaveScale, (String)"$this$shouldNotHaveScale");
        DslKt.shouldNotBe($this$shouldNotHaveScale.scale(), scale);
    }

    public static final void shouldBeLessThan(@NotNull BigDecimal $this$shouldBeLessThan, @NotNull BigDecimal other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeLessThan, (String)"$this$shouldBeLessThan");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        DslKt.shouldBe($this$shouldBeLessThan, ComparableMatchersKt.lt((Comparable)other));
    }

    public static final void shouldBeLessThanOrEquals(@NotNull BigDecimal $this$shouldBeLessThanOrEquals, @NotNull BigDecimal other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeLessThanOrEquals, (String)"$this$shouldBeLessThanOrEquals");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        DslKt.shouldBe($this$shouldBeLessThanOrEquals, ComparableMatchersKt.lte((Comparable)other));
    }

    public static final void shouldNotBeLessThan(@NotNull BigDecimal $this$shouldNotBeLessThan, @NotNull BigDecimal other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeLessThan, (String)"$this$shouldNotBeLessThan");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        DslKt.shouldNotBe($this$shouldNotBeLessThan, ComparableMatchersKt.lt((Comparable)other));
    }

    public static final void shouldNotBeLessThanOrEquals(@NotNull BigDecimal $this$shouldNotBeLessThanOrEquals, @NotNull BigDecimal other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeLessThanOrEquals, (String)"$this$shouldNotBeLessThanOrEquals");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        DslKt.shouldNotBe($this$shouldNotBeLessThanOrEquals, ComparableMatchersKt.lte((Comparable)other));
    }

    public static final void shouldBeGreaterThan(@NotNull BigDecimal $this$shouldBeGreaterThan, @NotNull BigDecimal other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeGreaterThan, (String)"$this$shouldBeGreaterThan");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        DslKt.shouldBe($this$shouldBeGreaterThan, ComparableMatchersKt.gt((Comparable)other));
    }

    public static final void shouldBeGreaterThanOrEquals(@NotNull BigDecimal $this$shouldBeGreaterThanOrEquals, @NotNull BigDecimal other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeGreaterThanOrEquals, (String)"$this$shouldBeGreaterThanOrEquals");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        DslKt.shouldBe($this$shouldBeGreaterThanOrEquals, ComparableMatchersKt.gte((Comparable)other));
    }

    public static final void shouldNotBeGreaterThan(@NotNull BigDecimal $this$shouldNotBeGreaterThan, @NotNull BigDecimal other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeGreaterThan, (String)"$this$shouldNotBeGreaterThan");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        DslKt.shouldNotBe($this$shouldNotBeGreaterThan, ComparableMatchersKt.gt((Comparable)other));
    }

    public static final void shouldNotBeGreaterThanOrEquals(@NotNull BigDecimal $this$shouldNotBeGreaterThanOrEquals, @NotNull BigDecimal other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeGreaterThanOrEquals, (String)"$this$shouldNotBeGreaterThanOrEquals");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        DslKt.shouldNotBe($this$shouldNotBeGreaterThanOrEquals, ComparableMatchersKt.gte((Comparable)other));
    }

    public static final void shouldBeInRange(@NotNull BigDecimal $this$shouldBeInRange, @NotNull ClosedRange<BigDecimal> range) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeInRange, (String)"$this$shouldBeInRange");
        Intrinsics.checkParameterIsNotNull(range, (String)"range");
        DslKt.should($this$shouldBeInRange, MatchersKt.beInClosedRange(range));
    }

    public static final void shouldNotBeInRange(@NotNull BigDecimal $this$shouldNotBeInRange, @NotNull ClosedRange<BigDecimal> range) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeInRange, (String)"$this$shouldNotBeInRange");
        Intrinsics.checkParameterIsNotNull(range, (String)"range");
        DslKt.shouldNot($this$shouldNotBeInRange, MatchersKt.beInClosedRange(range));
    }

    @NotNull
    public static final Matcher<BigDecimal> beInClosedRange(@NotNull ClosedRange<BigDecimal> range) {
        Intrinsics.checkParameterIsNotNull(range, (String)"range");
        return new Matcher<BigDecimal>(range){
            final /* synthetic */ ClosedRange $range;

            @NotNull
            public MatcherResult test(@NotNull BigDecimal value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(this.$range.contains((Comparable)value), "Value " + value + " should be in range from " + (BigDecimal)this.$range.getStart() + " to " + (BigDecimal)this.$range.getEndInclusive() + " (Inclusive)", "Value " + value + " should not be in range from " + (BigDecimal)this.$range.getStart() + " to " + (BigDecimal)this.$range.getEndInclusive() + " (Inclusive)");
            }
            {
                this.$range = $captured_local_variable$0;
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends BigDecimal> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap(this, f);
            }

            @NotNull
            public Matcher<BigDecimal> invert() {
                return Matcher.DefaultImpls.invert(this);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends BigDecimal> fn2) {
                Intrinsics.checkParameterIsNotNull(fn2, (String)"fn");
                return Matcher.DefaultImpls.compose(this, fn2);
            }

            @NotNull
            public Matcher<BigDecimal> and(@NotNull Matcher<BigDecimal> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and(this, other);
            }

            @NotNull
            public Matcher<BigDecimal> or(@NotNull Matcher<BigDecimal> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or(this, other);
            }
        };
    }
}

