/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.runner.junit5;

import io.kotlintest.TestCase;
import io.kotlintest.TestResult;
import io.kotlintest.TestStatus;
import io.kotlintest.runner.junit5.TestCaseContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.runners.model.TestTimedOutException;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/kotlintest/runner/junit5/TestCaseRunner;", "", "()V", "runTest", "Lio/kotlintest/TestResult;", "testCase", "Lio/kotlintest/TestCase;", "kotlintest-runner-junit5"})
public final class TestCaseRunner {
    public static final TestCaseRunner INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TestResult runTest(@NotNull TestCase testCase) {
        TestResult testResult;
        Intrinsics.checkParameterIsNotNull((Object)testCase, (String)"testCase");
        ExecutorService executor = Executors.newFixedThreadPool(testCase.getConfig().getThreads());
        if (testCase.isActive()) {
            Throwable first;
            Throwable throwable;
            TestCaseContext context = new TestCaseContext(testCase);
            List errors = new ArrayList();
            int n = 1;
            int n2 = testCase.getConfig().getInvocations();
            if (n <= n2) {
                while (true) {
                    void j;
                    executor.execute(new Runnable(testCase, context, errors){
                        final /* synthetic */ TestCase $testCase;
                        final /* synthetic */ TestCaseContext $context;
                        final /* synthetic */ List $errors;

                        public final void run() {
                            try {
                                this.$testCase.getTest().invoke((Object)this.$context);
                                Throwable result = this.$context.future().get();
                                if (result != null) {
                                    this.$errors.add(result);
                                }
                            }
                            catch (Throwable t) {
                                this.$errors.add(t);
                            }
                        }
                        {
                            this.$testCase = testCase;
                            this.$context = testCaseContext;
                            this.$errors = list;
                        }
                    });
                    if (j == n2) break;
                    ++j;
                }
            }
            executor.shutdown();
            Duration timeout = testCase.getConfig().getTimeout();
            boolean terminated = executor.awaitTermination(timeout.getSeconds(), TimeUnit.SECONDS);
            testResult = !terminated ? new TestResult(TestStatus.Error, (Throwable)new TestTimedOutException(timeout.getSeconds(), TimeUnit.SECONDS), context.metaData()) : ((throwable = (first = (Throwable)CollectionsKt.firstOrNull((List)errors))) == null ? new TestResult(TestStatus.Success, null, context.metaData()) : (throwable instanceof AssertionError ? new TestResult(TestStatus.Failure, first, context.metaData()) : new TestResult(TestStatus.Error, first, context.metaData())));
        } else {
            testResult = new TestResult(TestStatus.Ignored, null, null, 4, null);
        }
        return testResult;
    }

    private TestCaseRunner() {
    }

    static {
        TestCaseRunner testCaseRunner;
        INSTANCE = testCaseRunner = new TestCaseRunner();
    }
}

