/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.runner.jvm;

import arrow.Kind;
import arrow.core.Try;
import io.kotlintest.Project;
import io.kotlintest.Spec;
import io.kotlintest.TestCaseFilter;
import io.kotlintest.runner.jvm.JvmKt;
import io.kotlintest.runner.jvm.TestEngine;
import io.kotlintest.runner.jvm.TestEngineListener;
import io.kotlintest.runner.jvm.TryfuncsKt;
import io.kotlintest.runner.jvm.internal.NamedThreadFactory;
import io.kotlintest.runner.jvm.spec.SpecExecutor;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B9\u0012\u0014\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004H\u0002J\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\b\u0010#\u001a\u0004\u0018\u00010\u0011H\u0002J\u0006\u0010$\u001a\u00020\u001fJ\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u0018\u0010'\u001a\u00020\u001f2\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004H\u0002R\u001f\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n \u0014*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u0014*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/kotlintest/runner/jvm/TestEngine;", "", "classes", "", "Lkotlin/reflect/KClass;", "Lio/kotlintest/Spec;", "filters", "Lio/kotlintest/TestCaseFilter;", "parallelism", "", "listener", "Lio/kotlintest/runner/jvm/TestEngineListener;", "(Ljava/util/List;Ljava/util/List;ILio/kotlintest/runner/jvm/TestEngineListener;)V", "getClasses", "()Ljava/util/List;", "error", "Ljava/util/concurrent/atomic/AtomicReference;", "", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getListener", "()Lio/kotlintest/runner/jvm/TestEngineListener;", "logger", "Lorg/slf4j/Logger;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "specExecutor", "Lio/kotlintest/runner/jvm/spec/SpecExecutor;", "afterAll", "Larrow/core/Try;", "", "createSpec", "klass", "end", "t", "execute", "start", "submitAll", "submitSpec", "kotlintest-runner-jvm"})
public final class TestEngine {
    private final Logger logger;
    private final AtomicReference<Throwable> error;
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduler;
    private final SpecExecutor specExecutor;
    @NotNull
    private final List<KClass<? extends Spec>> classes;
    @NotNull
    private final TestEngineListener listener;

    private final Try<Unit> afterAll() {
        Try try_;
        Try.Companion this_$iv = Try.Companion;
        try {
            Unit unit;
            boolean bl = false;
            Project.INSTANCE.afterAll();
            Unit unit2 = unit = Unit.INSTANCE;
            try_ = (Try)new Try.Success((Object)unit2);
        }
        catch (Throwable e$iv) {
            try_ = (Try)new Try.Failure(e$iv);
        }
        return try_;
    }

    private final Try<Unit> start() {
        Try try_;
        Try.Companion this_$iv = Try.Companion;
        try {
            Unit unit;
            boolean bl = false;
            this.listener.engineStarted(this.classes);
            Project.INSTANCE.beforeAll();
            Unit unit2 = unit = Unit.INSTANCE;
            try_ = (Try)new Try.Success((Object)unit2);
        }
        catch (Throwable e$iv) {
            try_ = (Try)new Try.Failure(e$iv);
        }
        return try_;
    }

    private final Try<Unit> submitAll() {
        Try try_;
        Try.Companion this_$iv = Try.Companion;
        try {
            Unit unit;
            boolean bl = false;
            this.logger.debug("Submitting " + this.classes.size() + " specs");
            Iterable $receiver$iv = Project.INSTANCE.specExecutionOrder().sort(this.classes);
            for (Object element$iv : $receiver$iv) {
                KClass it = (KClass)element$iv;
                boolean bl2 = false;
                this.submitSpec((KClass<? extends Spec>)it);
            }
            this.executor.shutdown();
            this.logger.debug("Waiting for spec execution to terminate");
            try {
                this.executor.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException t) {
                this.error.compareAndSet(null, t);
            }
            Throwable t = this.error.get();
            if (t != null) {
                throw t;
            }
            Unit unit2 = unit = Unit.INSTANCE;
            try_ = (Try)new Try.Success((Object)unit2);
        }
        catch (Throwable e$iv) {
            try_ = (Try)new Try.Failure(e$iv);
        }
        return try_;
    }

    private final Try<Unit> end(Throwable t) {
        Try try_;
        Try.Companion this_$iv = Try.Companion;
        try {
            Unit unit;
            boolean bl = false;
            if (t != null) {
                this.logger.error("Error during test engine run", t);
                t.printStackTrace();
            }
            this.listener.engineFinished(t);
            Unit unit2 = unit = Unit.INSTANCE;
            try_ = (Try)new Try.Success((Object)unit2);
        }
        catch (Throwable e$iv) {
            try_ = (Try)new Try.Failure(e$iv);
        }
        return try_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void execute() {
        Try<Unit> try_;
        Try try_2;
        Try this_$iv = this.start();
        Try try_3 = this_$iv;
        if (try_3 instanceof Try.Failure) {
            try_2 = this_$iv;
        } else {
            Kind $receiver$iv$iv;
            if (!(try_3 instanceof Try.Success)) throw new NoWhenBranchMatchedException();
            Unit unit = (Unit)((Try.Success)this_$iv).getValue();
            boolean bl = false;
            Kind kind = $receiver$iv$iv = (Kind)this.submitAll();
            if (kind == null) {
                throw new TypeCastException("null cannot be cast to non-null type arrow.core.Try<A>");
            }
            try_2 = (Try)kind;
        }
        this_$iv = try_2;
        try_3 = this_$iv;
        if (try_3 instanceof Try.Failure) {
            Throwable throwable = ((Try.Failure)this_$iv).getException();
            boolean bl = false;
            this.afterAll();
            try_ = this.end(throwable);
            return;
        } else {
            if (!(try_3 instanceof Try.Success)) throw new NoWhenBranchMatchedException();
            Unit unit = (Unit)((Try.Success)this_$iv).getValue();
            boolean bl = false;
            Try<Unit> this_$iv2 = this.afterAll();
            Try<Unit> try_4 = this_$iv2;
            if (try_4 instanceof Try.Failure) {
                Throwable t = ((Try.Failure)this_$iv2).getException();
                boolean bl2 = false;
                try_ = this.end(t);
                return;
            } else {
                if (!(try_4 instanceof Try.Success)) throw new NoWhenBranchMatchedException();
                Unit it = (Unit)((Try.Success)this_$iv2).getValue();
                boolean bl3 = false;
                try_ = this.end(null);
            }
        }
    }

    private final void submitSpec(KClass<? extends Spec> klass) {
        this.executor.submit(new Runnable(this, klass){
            final /* synthetic */ TestEngine this$0;
            final /* synthetic */ KClass $klass;

            public final void run() {
                Try this_$iv = TestEngine.access$createSpec(this.this$0, this.$klass);
                Try try_ = this_$iv;
                if (try_ instanceof Try.Failure) {
                    Throwable t = ((Try.Failure)this_$iv).getException();
                    boolean bl = false;
                    this.this$0.getListener().beforeSpecClass((KClass<? extends Spec>)this.$klass);
                    this.this$0.getListener().afterSpecClass((KClass<? extends Spec>)this.$klass, t);
                    TestEngine.access$getError$p(this.this$0).compareAndSet(null, t);
                    TestEngine.access$getExecutor$p(this.this$0).shutdownNow();
                } else if (try_ instanceof Try.Success) {
                    Spec spec = (Spec)((Try.Success)this_$iv).getValue();
                    boolean bl = false;
                    TryfuncsKt.onFailure(TestEngine.access$getSpecExecutor$p(this.this$0).execute(spec), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this){
                        final /* synthetic */ submitSpec.1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        public final void invoke(@NotNull Throwable t) {
                            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                            TestEngine.access$getError$p(this.this$0.this$0).compareAndSet(null, t);
                            TestEngine.access$getExecutor$p(this.this$0.this$0).shutdownNow();
                        }
                    }));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            {
                this.this$0 = testEngine;
                this.$klass = kClass;
            }
        });
    }

    private final Try<Spec> createSpec(KClass<? extends Spec> klass) {
        Try try_;
        Try this_$iv = JvmKt.instantiateSpec(klass);
        Try try_2 = this_$iv;
        if (try_2 instanceof Try.Failure) {
            try_ = this_$iv;
        } else if (try_2 instanceof Try.Success) {
            Try try_3;
            Spec it = (Spec)((Try.Success)this_$iv).getValue();
            boolean bl = false;
            Try.Companion this_$iv2 = Try.Companion;
            try {
                Spec spec;
                boolean bl2 = false;
                this.listener.specCreated(it);
                Spec spec2 = spec = it;
                try_3 = (Try)new Try.Success((Object)spec2);
            }
            catch (Throwable e$iv) {
                try_3 = (Try)new Try.Failure(e$iv);
            }
            Kind $receiver$iv$iv = (Kind)try_3;
            try_ = (Try)$receiver$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return try_;
    }

    @NotNull
    public final List<KClass<? extends Spec>> getClasses() {
        return this.classes;
    }

    @NotNull
    public final TestEngineListener getListener() {
        return this.listener;
    }

    public TestEngine(@NotNull List<? extends KClass<? extends Spec>> classes, @NotNull List<? extends TestCaseFilter> filters, int parallelism, @NotNull TestEngineListener listener) {
        Intrinsics.checkParameterIsNotNull(classes, (String)"classes");
        Intrinsics.checkParameterIsNotNull(filters, (String)"filters");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.classes = classes;
        this.listener = listener;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.error = new AtomicReference<Object>(null);
        this.executor = Executors.newFixedThreadPool(parallelism, new NamedThreadFactory("kotlintest-engine-%d"));
        ScheduledExecutorService scheduledExecutorService = this.scheduler = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"scheduler");
        this.specExecutor = new SpecExecutor(this.listener, scheduledExecutorService);
        Project.INSTANCE.registerTestCaseFilter(filters);
    }

    public static final /* synthetic */ Try access$createSpec(TestEngine $this, KClass klass) {
        return $this.createSpec((KClass<? extends Spec>)klass);
    }

    public static final /* synthetic */ AtomicReference access$getError$p(TestEngine $this) {
        return $this.error;
    }

    public static final /* synthetic */ ExecutorService access$getExecutor$p(TestEngine $this) {
        return $this.executor;
    }

    public static final /* synthetic */ SpecExecutor access$getSpecExecutor$p(TestEngine $this) {
        return $this.specExecutor;
    }
}

