/*
 * Decompiled with CFR 0.152.
 */
package io.kotzilla.gradle.http;

import io.kotzilla.gradle.http.CloudInjectService;
import io.kotzilla.gradle.http.CloudInjectWebService;
import io.kotzilla.gradle.internal.AppInfo;
import io.ktor.util.Base64Kt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Response;
import retrofit2.Retrofit;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/kotzilla/gradle/http/CloudInjectServiceImpl;", "Lio/kotzilla/gradle/http/CloudInjectService;", "()V", "apiKey", "", "site", "version", "webService", "Lio/kotzilla/gradle/http/CloudInjectWebService;", "configure", "", "identifier", "Lio/kotzilla/gradle/internal/AppInfo;", "sendMapping", "mappingFile", "Ljava/io/File;", "cloud-inject-gradle"})
@SourceDebugExtension(value={"SMAP\nCloudInjectServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudInjectServiceImpl.kt\nio/kotzilla/gradle/http/CloudInjectServiceImpl\n+ 2 KotlinExtensions.kt\nretrofit2/KotlinExtensions\n*L\n1#1,106:1\n29#2:107\n*S KotlinDebug\n*F\n+ 1 CloudInjectServiceImpl.kt\nio/kotzilla/gradle/http/CloudInjectServiceImpl\n*L\n80#1:107\n*E\n"})
public final class CloudInjectServiceImpl
implements CloudInjectService {
    private String site;
    private String apiKey;
    private String version;
    private CloudInjectWebService webService;

    @Override
    public void configure(@NotNull String site, @NotNull String apiKey, @NotNull AppInfo identifier) {
        Intrinsics.checkNotNullParameter((Object)site, (String)"site");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        this.site = site;
        this.apiKey = Base64Kt.encodeBase64((String)apiKey);
        this.version = identifier.getVersion();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(site).build();
        Intrinsics.checkNotNull((Object)retrofit);
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        this.webService = (CloudInjectWebService)$this$create$iv.create(CloudInjectWebService.class);
    }

    @Override
    public void sendMapping(@NotNull File mappingFile) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)mappingFile, (String)"mappingFile");
        MultipartBody.Part requestBody = MultipartBody.Part.createFormData((String)"mapping", (String)mappingFile.getName(), (RequestBody)RequestBody.create((MediaType)MediaType.get((String)"multipart/form-data"), (File)mappingFile));
        CloudInjectWebService cloudInjectWebService = this.webService;
        if (cloudInjectWebService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webService");
            cloudInjectWebService = null;
        }
        if ((string2 = this.apiKey) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apiKey");
            string2 = null;
        }
        if ((string = this.version) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"version");
            string = null;
        }
        Intrinsics.checkNotNull((Object)requestBody);
        Response response = cloudInjectWebService.sendMapping(string2, string, requestBody).execute();
        StringBuilder stringBuilder = new StringBuilder().append("send mapping for version '");
        String string3 = this.version;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"version");
            string3 = null;
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("': ").append(response.code()).append(" - site:");
        String string4 = this.site;
        if (string4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"site");
            string4 = null;
        }
        System.err.println(stringBuilder2.append(string4).toString());
    }
}

