/*
 * Decompiled with CFR 0.152.
 */
package io.kotzilla.gradle.task;

import io.kotzilla.gradle.compression.Compression;
import io.kotzilla.gradle.http.CloudInjectServiceImpl;
import io.kotzilla.gradle.index.Indexer;
import io.kotzilla.gradle.internal.ApiKeySource;
import io.kotzilla.gradle.internal.AppInfo;
import io.kotzilla.gradle.internal.CloudInjectSite;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010$\u001a\u00020%H\u0007J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002R\u001c\u0010\u0005\u001a\u00020\u00068GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u00020\f8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u00020\u00068GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u001c\u0010\u0014\u001a\u00020\u00068GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\nR\u001c\u0010\u0017\u001a\u00020\u00068GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\b\"\u0004\b\u0019\u0010\nR\u0016\u0010\u001a\u001a\u00020\u001b8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u00020\u00068GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\b\"\u0004\b \u0010\nR\u001c\u0010!\u001a\u00020\u00068GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\b\"\u0004\b#\u0010\n\u00a8\u0006+"}, d2={"Lio/kotzilla/gradle/task/MappingFileUploadTask;", "Lorg/gradle/api/DefaultTask;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/provider/ProviderFactory;)V", "apiKey", "", "getApiKey", "()Ljava/lang/String;", "setApiKey", "(Ljava/lang/String;)V", "apiKeySource", "Lio/kotzilla/gradle/internal/ApiKeySource;", "getApiKeySource", "()Lio/kotzilla/gradle/internal/ApiKeySource;", "setApiKeySource", "(Lio/kotzilla/gradle/internal/ApiKeySource;)V", "applicationId", "getApplicationId", "setApplicationId", "mappingFilePath", "getMappingFilePath", "setMappingFilePath", "site", "getSite", "setSite", "uploader", "Lio/kotzilla/gradle/http/CloudInjectServiceImpl;", "getUploader$cloud_inject_gradle", "()Lio/kotzilla/gradle/http/CloudInjectServiceImpl;", "variantName", "getVariantName", "setVariantName", "versionName", "getVersionName", "setVersionName", "applyTask", "", "validateMappingFile", "", "mappingFile", "Ljava/io/File;", "Companion", "cloud-inject-gradle"})
@SourceDebugExtension(value={"SMAP\nMappingFileUploadTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappingFileUploadTask.kt\nio/kotzilla/gradle/task/MappingFileUploadTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n1#2:243\n*E\n"})
public class MappingFileUploadTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloudInjectServiceImpl uploader;
    @NotNull
    private String apiKey;
    @NotNull
    private ApiKeySource apiKeySource;
    @NotNull
    private String variantName;
    @NotNull
    private String versionName;
    @NotNull
    private String applicationId;
    @NotNull
    private String site;
    @NotNull
    private String mappingFilePath;

    @Inject
    public MappingFileUploadTask(@NotNull ProviderFactory providerFactory) {
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        this.uploader = new CloudInjectServiceImpl();
        this.apiKey = "";
        this.apiKeySource = ApiKeySource.NONE;
        this.variantName = "";
        this.versionName = "";
        this.applicationId = "";
        this.site = "";
        this.mappingFilePath = "";
        this.setGroup("cloud-inject");
        this.setDescription("Upload Proguard/R8 mapping file to Cloud-Inject");
        this.getOutputs().upToDateWhen(arg_0 -> MappingFileUploadTask._init_$lambda$0(1.INSTANCE, arg_0));
    }

    @Internal
    @NotNull
    public final CloudInjectServiceImpl getUploader$cloud_inject_gradle() {
        return this.uploader;
    }

    @Input
    @NotNull
    public final String getApiKey() {
        return this.apiKey;
    }

    public final void setApiKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.apiKey = string;
    }

    @Input
    @NotNull
    public final ApiKeySource getApiKeySource() {
        return this.apiKeySource;
    }

    public final void setApiKeySource(@NotNull ApiKeySource apiKeySource) {
        Intrinsics.checkNotNullParameter((Object)((Object)apiKeySource), (String)"<set-?>");
        this.apiKeySource = apiKeySource;
    }

    @Input
    @NotNull
    public final String getVariantName() {
        return this.variantName;
    }

    public final void setVariantName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.variantName = string;
    }

    @Input
    @NotNull
    public final String getVersionName() {
        return this.versionName;
    }

    public final void setVersionName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.versionName = string;
    }

    @Input
    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    public final void setApplicationId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.applicationId = string;
    }

    @Input
    @NotNull
    public final String getSite() {
        return this.site;
    }

    public final void setSite(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.site = string;
    }

    @Input
    @NotNull
    public final String getMappingFilePath() {
        return this.mappingFilePath;
    }

    public final void setMappingFilePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.mappingFilePath = string;
    }

    @TaskAction
    public final void applyTask() {
        CharSequence charSequence;
        CharSequence charSequence2 = this.site;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = CloudInjectSite.METADATA.getDomain$cloud_inject_gradle();
        } else {
            charSequence = charSequence2;
        }
        String site = (String)charSequence;
        this.uploader.configure(site, this.apiKey, new AppInfo(this.applicationId, this.versionName, this.variantName));
        File mappingFile = new File(this.mappingFilePath);
        if (!this.validateMappingFile(mappingFile)) {
            return;
        }
        String mappingFileGzPath = this.mappingFilePath + ".gz";
        Compression.INSTANCE.gzip(this.mappingFilePath, mappingFileGzPath);
        List<Pair<String, String>> index = Indexer.INSTANCE.extractClassIndex(this.mappingFilePath);
        String indexContent = Indexer.INSTANCE.saveClassIndex(index);
        String mappingFileIndexPath = this.mappingFilePath + ".index";
        Indexer.INSTANCE.saveClassIndexFile(indexContent, mappingFileIndexPath);
        String mappingFileIndexGzPath = this.mappingFilePath + ".index.gz";
        Compression.INSTANCE.gzip(mappingFileIndexPath, mappingFileIndexGzPath);
        this.uploader.sendMapping(new File(mappingFileGzPath));
    }

    private final boolean validateMappingFile(File mappingFile) {
        if (!mappingFile.exists()) {
            System.out.println((Object)("There's no mapping file " + this.mappingFilePath + ", nothing to upload"));
            return false;
        }
        if (!mappingFile.isFile()) {
            boolean $i$a$-check-MappingFileUploadTask$validateMappingFile$32 = false;
            String $i$a$-check-MappingFileUploadTask$validateMappingFile$32 = "Expected " + this.mappingFilePath + " to be a file";
            throw new IllegalStateException($i$a$-check-MappingFileUploadTask$validateMappingFile$32.toString());
        }
        if (!mappingFile.canRead()) {
            boolean bl = false;
            String string = "Cannot read file " + this.mappingFilePath;
            throw new IllegalStateException(string.toString());
        }
        return true;
    }

    private static final boolean _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/kotzilla/gradle/task/MappingFileUploadTask$Companion;", "", "()V", "cloud-inject-gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

